/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordAppGetDescriptionById
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"eb476682-5717-4390-b223-336e13799bd5");
    public static final String NAME = "AppGetDescriptionById";
    public static final String DESCRIPTION = "Get an application description by ID. Direction: Public --> Application Factory Registry";
    public static final String SLOT_APPLICATION_DESCRIPTION = "2";
    public static final String SLOT_APPLICATION_ID = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord getApplicationDescription(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static UUID getApplicationId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static void setApplicationDescription(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_DESCRIPTION, slot);
    }

    public static void setApplicationId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_ID, slot);
    }
}

