/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.link.cost.collector.CCostEntry;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkList;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class CUtilBroadcast {
    private CUtilBroadcast() {
    }

    @NotNull
    static CRecord createRecordWithCosts(@NotNull Collection<CCostEntry> aLinks) throws CException {
        Set<CNodeAddress> setOfNodeIds = CUtilBroadcast.createSetOfNodeIds(aLinks);
        CNodeAddress[] nodes = new CNodeAddress[setOfNodeIds.size()];
        nodes = setOfNodeIds.toArray(nodes);
        int linkCount = aLinks.size();
        int[] index1 = new int[linkCount];
        int[] index2 = new int[linkCount];
        ZonedDateTime[] costMeasureTimes = new ZonedDateTime[linkCount];
        int[] costs = new int[linkCount];
        int i = 0;
        for (CCostEntry link : aLinks) {
            CNodeAddress node1 = new CNodeAddress(link.getKey().getNode1());
            index1[i] = CUtilBroadcast.getIndex(nodes, node1);
            CNodeAddress node2 = new CNodeAddress(link.getKey().getNode2());
            index2[i] = CUtilBroadcast.getIndex(nodes, node2);
            costMeasureTimes[i] = link.getCostMeasureTime();
            costs[i] = link.getCosts();
            ++i;
        }
        CRecord record = CRecordNetworkLinkList.create();
        CRecordNetworkLinkList.setNodeAddresses((CRecord)record, (CNodeAddress[])nodes);
        CRecordNetworkLinkList.setNodeIndex1((CRecord)record, (int[])index1);
        CRecordNetworkLinkList.setNodeIndex2((CRecord)record, (int[])index2);
        CRecordNetworkLinkList.setCostMeasureTimes((CRecord)record, (ZonedDateTime[])costMeasureTimes);
        CRecordNetworkLinkList.setCosts((CRecord)record, (int[])costs);
        return record;
    }

    @NotNull
    private static Set<CNodeAddress> createSetOfNodeIds(@NotNull Collection<CCostEntry> aLinks) {
        HashSet<CNodeAddress> nodeArray = new HashSet<CNodeAddress>();
        for (CCostEntry link : aLinks) {
            CNodeId nodeId1 = link.getKey().getNode1();
            CNodeAddress node1 = new CNodeAddress(nodeId1);
            nodeArray.add(node1);
            CNodeId nodeId2 = link.getKey().getNode2();
            CNodeAddress node2 = new CNodeAddress(nodeId2);
            nodeArray.add(node2);
        }
        return nodeArray;
    }

    @Contract(pure=true)
    private static int getIndex(CNodeAddress @NotNull [] aNodeIdArray, CNodeAddress aSearch) {
        for (int i = 0; i < aNodeIdArray.length; ++i) {
            if (!aNodeIdArray[i].equals((Object)aSearch)) continue;
            return i;
        }
        return -1;
    }
}

