/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import de.sillysky.nyssr.impl.network.link.cost.collector.CLinkKey;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

class CCostEntry {
    private final CLinkKey mKey;
    private final boolean mFix;
    private int mCosts;
    private ZonedDateTime mLastUpdate;

    CCostEntry(@NotNull CLinkKey aKey, int aCosts, boolean aFix) {
        this.mKey = aKey;
        this.mCosts = aCosts;
        this.mFix = aFix;
        this.mLastUpdate = ZonedDateTime.now();
    }

    public int getCosts() {
        return this.mCosts;
    }

    public void setCosts(int aCosts) {
        this.mCosts = aCosts;
        this.mLastUpdate = ZonedDateTime.now();
    }

    public CLinkKey getKey() {
        return this.mKey;
    }

    public boolean isFix() {
        return this.mFix;
    }

    boolean canBeRemoved(int aTimeoutInSeconds) {
        ZonedDateTime maxTime = this.mLastUpdate.plusSeconds(aTimeoutInSeconds);
        ZonedDateTime now = ZonedDateTime.now();
        return now.isAfter(maxTime);
    }

    public ZonedDateTime getCostMeasureTime() {
        return this.mLastUpdate;
    }
}

