/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.application;

import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.network.index.application.CApplication;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CFactory
implements IApplicationFactory,
IService {
    private IRecordHelper mRecordHelper;

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IApplicationFactoryRegistry.class);
        aDependencyList.add(IRecordHelper.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        IApplicationFactoryRegistry applicationFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        if (applicationFactoryRegistry != null) {
            applicationFactoryRegistry.registerFactory((IApplicationFactory)this);
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IApplicationFactoryRegistry applicationFactoryRegistry = (IApplicationFactoryRegistry)aServiceRegistry.getService(IApplicationFactoryRegistry.class);
        if (applicationFactoryRegistry != null) {
            applicationFactoryRegistry.deregisterFactory((IApplicationFactory)this);
        }
    }

    public IApplicationDescription getApplicationDescription() {
        return CApplication.mDesc;
    }

    public void notifyStopped(@NotNull UUID aInstanceId) {
    }

    @NotNull
    public IApplication start(@NotNull IApplicationContext aContext) throws CException {
        CUtilCheck.checkNotNull((Object)aContext, (String)"application entry is empty.", (Object[])new Object[0]);
        CApplication app = new CApplication();
        app.activate(this.mRecordHelper);
        app.start(aContext);
        return app;
    }

    public boolean stopSafely(@NotNull IApplication aApplication) throws Exception {
        boolean ok = aApplication.requestStop();
        if (ok) {
            aApplication.stop();
            aApplication.notifyStopped();
            return true;
        }
        return false;
    }
}

