/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.helper;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.helper.CLocalMicroServiceList;
import de.sillysky.nyssr.impl.microservice.helper.IPrivateHelperForLocalMicroServices;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.collector.CMicroServiceInstance;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.microservice.helper.IHelperForLocalMicroServices;
import de.sillysky.nyssr.microservice.registry.records.CRecordRegisterMicroService;
import de.sillysky.nyssr.microservice.registry.records.CRecordRemoveMicroServiceInstance;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CHelperForLocalMicroServices
implements IService,
IHelperForLocalMicroServices,
IPrivateHelperForLocalMicroServices {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHelperForLocalMicroServices.class);
    private final CLocalMicroServiceList mLocalMicroServices = new CLocalMicroServiceList();
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;
    private final AtomicReference<ITarget> mTarget = new AtomicReference();
    private CTargetAddress mNearRegistryAddress;

    CHelperForLocalMicroServices() {
    }

    static void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getService(IMicroServiceRegistryCollector.class);
        CUtilCheck.checkNotNull((Object)this.mMicroServiceRegistryCollector, (String)"Missing Collector", (Object[])new Object[0]);
        this.mNearRegistryAddress = this.mMicroServiceRegistryCollector.getNextAddress();
        aServiceRegistry.registerService(IHelperForLocalMicroServices.class, (Object)this);
        aServiceRegistry.registerService(IPrivateHelperForLocalMicroServices.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public boolean registerMicroService(@NotNull CMicroServiceInstance aInstance) throws CException {
        boolean result = this.mLocalMicroServices.add(aInstance);
        if (result) {
            this.privateSendRegisterToRegistry(aInstance);
        }
        return result;
    }

    public boolean registerMicroService(@NotNull IId aMicroServiceId, @NotNull String aDescription, @NotNull Collection<CDescriptionOfRecord> aNanoServices, @NotNull IId aInstanceId, @NotNull CTargetAddress aInstanceAddress) throws CException {
        CMicroServiceDescription desc = new CMicroServiceDescription(aMicroServiceId, aDescription, aNanoServices);
        CMicroServiceInstance instance = new CMicroServiceInstance(desc, aInstanceId, aInstanceAddress);
        return this.registerMicroService(instance);
    }

    public void deregisterMicroServices(@NotNull CTargetAddress aOwner) throws CException {
        List<CMicroServiceInstance> list = this.mLocalMicroServices.getFromOwner(aOwner);
        for (CMicroServiceInstance inst : list) {
            this.deregisterMicroService(inst.getDescription().getId(), inst.getInstanceId());
        }
    }

    public void deregisterMicroService(@NotNull IId aMicroserviceId, @NotNull IId aInstanceId) throws CException {
        boolean success = this.privateSendDeregisterMicroService(aMicroserviceId, aInstanceId);
        if (success) {
            this.mLocalMicroServices.remove(aInstanceId);
        }
    }

    @Override
    public void setTarget(@Nullable ITarget aTarget) {
        this.mTarget.set(aTarget);
    }

    @Override
    public void notifyMicroServiceRegistryAdded(@NotNull CTargetAddress aAddress) {
        this.mNearRegistryAddress = this.mMicroServiceRegistryCollector.getNextAddress();
        if (this.mNearRegistryAddress != null) {
            try {
                this.privateRegisterPendingServices();
            }
            catch (CException aE) {
                LOG.error((Throwable)aE);
            }
        }
    }

    void privateRegisterPendingServices() throws CException {
        List<CMicroServiceInstance> pending = this.mLocalMicroServices.getPending();
        for (CMicroServiceInstance inst : pending) {
            boolean success = this.privateSendRegisterToRegistry(inst);
            if (!success) continue;
        }
    }

    private boolean privateSendRegisterToRegistry(@NotNull CMicroServiceInstance aInstance) throws CException {
        ITarget target = this.mTarget.get();
        if (target != null && this.mNearRegistryAddress != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mNearRegistryAddress);
            IId instanceId = aInstance.getInstanceId();
            CMicroServiceDescription desc = aInstance.getDescription();
            CRecord recMS = desc.valueToRecord();
            CTargetAddress targetAddress = aInstance.getTargetAddress();
            CRecord rec = CRecordRegisterMicroService.create();
            CRecordRegisterMicroService.setMicroService((CRecord)rec, (CRecord)recMS);
            CRecordRegisterMicroService.setInstanceId((CRecord)rec, (IId)instanceId);
            CRecordRegisterMicroService.setAddress((CRecord)rec, (CTargetAddress)targetAddress);
            target.sendRequest(env, rec);
            return true;
        }
        return false;
    }

    private boolean privateSendDeregisterMicroService(@NotNull IId aId, @NotNull IId aInstanceId) throws CException {
        ITarget target = this.mTarget.get();
        if (target != null && this.mNearRegistryAddress != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mNearRegistryAddress);
            CRecord rec = CRecordRemoveMicroServiceInstance.create();
            CRecordRemoveMicroServiceInstance.setMicroServiceId((CRecord)rec, (IId)aId);
            CRecordRemoveMicroServiceInstance.setMicroServiceInstanceId((CRecord)rec, (IId)aInstanceId);
            target.sendRequest(env, rec);
            return true;
        }
        return false;
    }
}

