/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventSelectText
implements IRemoteSkinEvent {
    private static final String POS_START = "start";
    private static final String POS_END = "end";
    private static final String TEXT = "text";
    private static final String ALL = "all";
    private int mPosStart = -1;
    private int mPosEnd = -1;
    private String mText = null;
    private Boolean mAll = null;

    public CEventSelectText(int aPosStart, int aPosEnd) {
        this.mPosStart = aPosStart;
        this.mPosEnd = aPosEnd;
    }

    public CEventSelectText(@NotNull String aText) {
        this.mText = aText;
    }

    public CEventSelectText() {
        this.mAll = Boolean.TRUE;
    }

    @Nullable
    public static CEventSelectText create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int start = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)POS_START, (int)-1);
            int end = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)POS_END, (int)-1);
            if (start >= 0 && end >= 0) {
                return new CEventSelectText(start, end);
            }
            String text = CUtilJsonString.fromJson((CJsonObject)jo, (String)TEXT, null);
            if (text != null) {
                return new CEventSelectText(text);
            }
            Boolean all = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)ALL);
            if (all != null) {
                return new CEventSelectText();
            }
        }
        return null;
    }

    public int getPosStart() {
        return this.mPosStart;
    }

    public int getPosEnd() {
        return this.mPosEnd;
    }

    public String getText() {
        return this.mText;
    }

    public Boolean getAll() {
        return this.mAll;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mPosStart >= 0) {
            jo.put(POS_START, (Object)this.mPosStart);
        }
        if (this.mPosEnd >= 0) {
            jo.put(POS_END, (Object)this.mPosEnd);
        }
        if (CUtilString.isValid((String)this.mText)) {
            jo.put(TEXT, (Object)this.mText);
        }
        if (this.mAll != null) {
            jo.put(ALL, (Object)this.mAll);
        }
        return jo;
    }
}

