/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryList;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTargetRunApplication
extends CTarget {
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private final CApplicationFactoryList mFactories;
    private CApplicationFactoryEntry mFactoryEntry;

    CTargetRunApplication(@NotNull CApplicationFactoryList aFactories, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mFactories = aFactories;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        UUID applicationId = CRecordLaunchApplication.getApplicationId((CRecord)this.mRecord, null);
        this.mFactoryEntry = this.mFactories.getFactoryEntry(applicationId);
        if (this.mFactoryEntry == null) {
            this.finish(new CResult(5, "Application not found."));
        } else {
            @NotNull String[] permissions = this.mFactoryEntry.getApplication().getPermissions();
            if (permissions.length == 0) {
                CResult result = this.startApplication();
                this.finish(result);
            } else {
                String sessionToken = CRecordLaunchApplication.getSessionToken((CRecord)this.mRecord, null);
                if (sessionToken == null) {
                    this.finish(new CResult(8, "Missing session token"));
                } else {
                    this.sendGetPermissions(sessionToken);
                }
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            CResult result;
            switch (aEnvelope.getResultCode()) {
                case 0: {
                    String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                    try {
                        CApplicationEntry application = this.mFactoryEntry.getApplication();
                        if (application.isStartingAllowed(rights)) {
                            result = this.startApplication();
                            break;
                        }
                        result = new CResult(5105, "Missing right.");
                    }
                    catch (CException aE) {
                        result = new CResult(aE);
                    }
                    break;
                }
                case 2001: {
                    result = new CResult(5102, "Can't validate Token");
                    break;
                }
                default: {
                    result = aEnvelope.getResult();
                }
            }
            this.finish(result);
            return true;
        }
        return false;
    }

    private void sendGetPermissions(@NotNull String aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        CRecord record = CRecordSessionValidate.create();
        CRecordSessionValidate.setToken((CRecord)record, (String)aSessionToken);
        this.sendRequest(env, record);
    }

    private void finish(@Nullable CResult aResult) throws CException {
        if (aResult != null) {
            this.mEnvelope.setResult(aResult);
            this.mEnvelope.setBlocked(false);
            this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        } else {
            this.mEnvelope.setBlocked(false);
            this.getMessageSender().send(this.mEnvelope, this.mRecord);
        }
        this.deregisterTarget();
    }

    @Nullable
    private CResult startApplication() throws CException {
        CTargetAddress address = this.mFactoryEntry.getNextFactory();
        if (address == null) {
            return new CResult(5, "No application factory found.");
        }
        this.mEnvelope.setReceiver(address);
        return null;
    }
}

