/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationEntry;
import de.sillysky.nyssr.util.CUtilRandom;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CApplicationFactoryEntry
implements Comparable<CApplicationFactoryEntry> {
    private final Set<CTargetAddress> mFactoryAddresses = new HashSet<CTargetAddress>();
    @NotNull
    private final CApplicationEntry mApplication;

    CApplicationFactoryEntry(@NotNull CApplicationEntry aApplication) {
        this.mApplication = aApplication;
    }

    @NotNull
    CApplicationEntry getApplication() {
        return this.mApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CTargetAddress getNextFactory() {
        Set<CTargetAddress> set = this.mFactoryAddresses;
        synchronized (set) {
            int size = this.mFactoryAddresses.size();
            if (size > 0) {
                int index = 0;
                if (size > 1) {
                    Random random = CUtilRandom.getRandom();
                    index = random.nextInt(size);
                }
                int i = 0;
                for (CTargetAddress a : this.mFactoryAddresses) {
                    if (i == index) {
                        return a;
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addFactory(@NotNull CTargetAddress aAddress) {
        Set<CTargetAddress> set = this.mFactoryAddresses;
        synchronized (set) {
            return this.mFactoryAddresses.add(aAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFactory(@NotNull CTargetAddress aAddress) {
        Set<CTargetAddress> set = this.mFactoryAddresses;
        synchronized (set) {
            return this.mFactoryAddresses.remove(aAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNamespace(@NotNull CNamespaceAddress aAddress) {
        Set<CTargetAddress> set = this.mFactoryAddresses;
        synchronized (set) {
            this.mFactoryAddresses.removeIf(address -> address.getNamespaceAddress().equals((Object)aAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNode(@NotNull CNodeAddress aAddress) {
        Set<CTargetAddress> set = this.mFactoryAddresses;
        synchronized (set) {
            return this.mFactoryAddresses.removeIf(address -> address.getNodeAddress().equals((Object)aAddress));
        }
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CApplicationFactoryEntry that = (CApplicationFactoryEntry)aO;
        return this.mApplication.equals(that.mApplication);
    }

    public int hashCode() {
        return this.mApplication.hashCode();
    }

    @Override
    public int compareTo(@NotNull CApplicationFactoryEntry aOther) {
        return this.mApplication.getApplicationName().compareTo(aOther.getApplication().getApplicationName());
    }
}

