/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.manager;

import de.sillysky.nyssr.database.IH2DatabaseFactory;
import de.sillysky.nyssr.impl.session.manager.CSessionManager;
import de.sillysky.nyssr.impl.session.manager.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.microservice.helper.IHelperForLocalMicroServices;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.broadcast.IBroadcastService;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CPackageImplSessionManager
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INamespaceFactory mNamespaceFactory;
    private IKernelConfiguration mKernelConfiguration;
    private IHelperForLocalMicroServices mHelperForLocalMicroServices;
    private IH2DatabaseFactory mH2DatabaseFactory;
    private ITimerManager mTimerManager;
    private IBroadcastService mBroadCastService;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IHelperForLocalMicroServices.class);
        aDependencyList.add(IH2DatabaseFactory.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(IBroadcastService.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mHelperForLocalMicroServices = (IHelperForLocalMicroServices)aServiceRegistry.getServiceOrThrow(IHelperForLocalMicroServices.class);
            this.mH2DatabaseFactory = (IH2DatabaseFactory)aServiceRegistry.getServiceOrThrow(IH2DatabaseFactory.class);
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mBroadCastService = (IBroadcastService)aServiceRegistry.getServiceOrThrow(IBroadcastService.class);
            this.mService = new CSessionManager(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    @NotNull
    public IHelperForLocalMicroServices getHelperForLocalMicroServices() {
        return this.mHelperForLocalMicroServices;
    }

    @Override
    @NotNull
    public IH2DatabaseFactory getH2DatabaseFactory() {
        return this.mH2DatabaseFactory;
    }

    @Override
    @NotNull
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    @NotNull
    public IBroadcastService getBroadcastService() {
        return this.mBroadCastService;
    }
}

