/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CUser;
import org.jetbrains.annotations.NotNull;

class C701Handler {
    private final CMainTarget mMainTarget;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs701;
    private final CWidgetId m701Dialog;
    private final CWidgetId m701ButtonOkay;
    private final CWidgetId m701ButtonCancel;
    private final CWidgetId m701UserId;
    private final CWidgetId m701RealName;
    private final CWidgetId m701Email;
    private final IRemoteSkinServerContext mServerContext;
    private String mEnteredUserId = "";
    private String mEnteredRealName = "";
    private String mEnteredEmail = "";
    private boolean m701ButtonOkayIsEnabled;
    private boolean m701open;
    private CWidgetId mParentWidget;
    private CUser mUser;

    public C701Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs701 = CWidgetSetId.create((String)"@701_EditUser", (String)aInstance);
        this.m701Dialog = CWidgetId.create((String)"#701_Dialog", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m701ButtonOkay = CWidgetId.create((String)"#701_ButtonOkay", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m701ButtonCancel = CWidgetId.create((String)"#701_ButtonCancel", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
        this.m701UserId = CWidgetId.create((String)"#701_TextFieldUserId", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701UserId, (IListener)((ITextChangeListener)this::onTextChangeUserId));
        this.m701RealName = CWidgetId.create((String)"#701_TextFieldRealName", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701RealName, (IListener)((ITextChangeListener)this::onTextChangeRealName));
        this.m701Email = CWidgetId.create((String)"#701_TextFieldEmail", (CWidgetSetId)this.mWs701);
        this.mApi.addListener(this.m701Email, (IListener)((ITextChangeListener)this::onTextChangeEmail));
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs701.equals((Object)aWidgetSetId)) {
            this.m701open = true;
            this.mApi.pack(this.m701Dialog);
            this.mApi.centerWidget(this.m701Dialog, this.mParentWidget);
            this.mApi.setVisible(this.m701Dialog, true);
            this.mApi.setText(this.m701UserId, this.mUser.getId());
            this.mApi.setText(this.m701RealName, this.mUser.getRealName());
            this.mApi.setText(this.m701Email, this.mUser.getEmail());
            this.mApi.setEnabled(this.m701UserId, false);
            this.sendUpdate();
        }
    }

    private void updateButtons() {
        boolean changed2 = !this.mEnteredEmail.equals(this.mUser.getEmail()) || !this.mEnteredRealName.equals(this.mUser.getRealName());
        this.enableButtonOkay(changed2);
    }

    private void enableButtonOkay(boolean aEnabled) {
        if (this.m701ButtonOkayIsEnabled != aEnabled) {
            this.m701ButtonOkayIsEnabled = aEnabled;
            this.mApi.setEnabled(this.m701ButtonOkay, this.m701ButtonOkayIsEnabled);
            this.sendUpdate();
        }
    }

    private void onTextChangeUserId(@NotNull CEventTextChangeNotification aEvent) {
        this.mEnteredUserId = aEvent.getText();
        this.updateButtons();
    }

    private void onTextChangeRealName(@NotNull CEventTextChangeNotification aEvent) {
        this.mEnteredRealName = aEvent.getText();
        this.updateButtons();
    }

    private void onTextChangeEmail(@NotNull CEventTextChangeNotification aEvent) {
        this.mEnteredEmail = aEvent.getText();
        this.updateButtons();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.sendUpdateUserData(this.mUser.getId(), this.mEnteredRealName, this.mEnteredEmail);
        this.unmount();
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget, @NotNull CUser aUser) {
        if (!this.m701open) {
            this.mUser = new CUser(aUser);
            this.mParentWidget = aParentWidget;
            this.m701ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs701, aParentWidget, "#701_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m701open) {
            this.m701open = false;
            this.mApi.unmount(this.m701Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }
}

