/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkList;
import de.sillysky.nyssr.record.CRecord;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class CUtilLinkList {
    private CUtilLinkList() {
    }

    @NotNull
    static CRecord createRecordWithCosts(@NotNull List<CDijkstraLink> aLinks) throws CException {
        Set<CNodeAddress> setOfNodeIds = CUtilLinkList.createSetOfNodeIds(aLinks);
        CNodeAddress[] nodes = new CNodeAddress[setOfNodeIds.size()];
        nodes = setOfNodeIds.toArray(nodes);
        int linkCount = aLinks.size();
        int[] index1 = new int[linkCount];
        int[] index2 = new int[linkCount];
        ZonedDateTime[] costMeasureTimes = new ZonedDateTime[linkCount];
        int[] costs = new int[linkCount];
        int i = 0;
        for (CDijkstraLink link : aLinks) {
            CNodeAddress node1 = link.getNode1();
            index1[i] = CUtilLinkList.getIndex(nodes, node1);
            CNodeAddress node2 = link.getNode2();
            index2[i] = CUtilLinkList.getIndex(nodes, node2);
            costMeasureTimes[i] = link.getCostMeasureTime();
            costs[i] = link.getCosts();
            ++i;
        }
        CRecord record = CRecordNetworkLinkList.create();
        CRecordNetworkLinkList.setNodeAddresses((CRecord)record, (CNodeAddress[])nodes);
        CRecordNetworkLinkList.setNodeIndex1((CRecord)record, (int[])index1);
        CRecordNetworkLinkList.setNodeIndex2((CRecord)record, (int[])index2);
        CRecordNetworkLinkList.setCostMeasureTimes((CRecord)record, (ZonedDateTime[])costMeasureTimes);
        CRecordNetworkLinkList.setCosts((CRecord)record, (int[])costs);
        return record;
    }

    @NotNull
    private static Set<CNodeAddress> createSetOfNodeIds(@NotNull List<CDijkstraLink> aLinks) {
        HashSet<CNodeAddress> nodeArray = new HashSet<CNodeAddress>();
        for (CDijkstraLink link : aLinks) {
            CNodeAddress node1 = link.getNode1();
            CNodeAddress node2 = link.getNode2();
            nodeArray.add(node1);
            nodeArray.add(node2);
        }
        return nodeArray;
    }

    @Contract(pure=true)
    private static int getIndex(CNodeAddress @NotNull [] aNodeIdArray, CNodeAddress aSearch) {
        for (int i = 0; i < aNodeIdArray.length; ++i) {
            if (!aNodeIdArray[i].equals((Object)aSearch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    static List<CDijkstraLink> fromRecord(@NotNull CRecord aRecord) throws CException {
        CUtilLinkList.checkRecordId(aRecord);
        CNodeAddress[] nodeIds = CRecordNetworkLinkList.getNodeAddresses((CRecord)aRecord, null);
        int[] nodeIndex1 = CRecordNetworkLinkList.getNodeIndex1((CRecord)aRecord, null);
        int[] nodeIndex2 = CRecordNetworkLinkList.getNodeIndex2((CRecord)aRecord, null);
        int[] costs = CRecordNetworkLinkList.getCosts((CRecord)aRecord, null);
        ZonedDateTime[] costMeasureTimes = CRecordNetworkLinkList.getCostMeasureTimes((CRecord)aRecord, null);
        CUtilLinkList.checkConsistency(nodeIds, nodeIndex1, nodeIndex2, costs, costMeasureTimes);
        ArrayList<CDijkstraLink> list = new ArrayList<CDijkstraLink>();
        for (int i = 0; i < nodeIndex1.length; ++i) {
            CNodeAddress node1 = nodeIds[nodeIndex1[i]];
            CNodeAddress node2 = nodeIds[nodeIndex2[i]];
            CDijkstraLink link = new CDijkstraLink(node1, node2, costMeasureTimes[i], costs[i]);
            list.add(link);
        }
        return list;
    }

    private static void checkConsistency(CNodeAddress[] aNodeIds, int[] aNodeIndex1, int[] aNodeIndex2, int[] aCosts, ZonedDateTime[] aCostMeasureTimes) throws CException {
        boolean err = false;
        if (aNodeIds == null || aNodeIds.length == 0 || aNodeIndex1 == null || aNodeIndex2 == null || aCosts == null || aCostMeasureTimes == null) {
            err = true;
        } else {
            int l = aNodeIndex1.length;
            if (l == 0 || aNodeIndex2.length != l || aCosts.length != l || aCostMeasureTimes.length != l) {
                err = true;
            }
        }
        if (err) {
            throw new CException(6);
        }
    }

    private static void checkRecordId(@NotNull CRecord aARecord) throws CException {
        if (!CRecordNetworkLinkList.ID.equals((Object)aARecord.getId())) {
            throw new CException(2010);
        }
    }
}

