/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.router.CDijkstraAlgorithm;
import de.sillysky.nyssr.impl.network.router.CDijkstraLinkList;
import de.sillysky.nyssr.impl.network.router.CDijkstraNeighbor;
import de.sillysky.nyssr.impl.network.router.CDirectLinks;
import de.sillysky.nyssr.impl.network.router.CUtilLinkList;
import de.sillysky.nyssr.impl.network.router.IDependencies;
import de.sillysky.nyssr.impl.network.router.IDijkstraLinkListListener;
import de.sillysky.nyssr.impl.network.router.IInternalRouter;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.network.router.records.CRecordNetworkLinkList;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyNodeLinkDeleted;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyUpdateNodeLinkList;
import de.sillysky.nyssr.network.router.records.CRecordNetworkRenewNodeRecord;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilString;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CRouter
implements IRouter,
IInternalRouter,
IDijkstraLinkListListener,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRouter.class);
    private final Boolean mReachableNodesMutex = Boolean.FALSE;
    private final IDependencies mDependencies;
    private final CDirectLinks mDirectLinks;
    private CDijkstraAlgorithm mDijkstra;
    private CDijkstraLinkList mLinkList;
    private ITarget mTarget;
    private Set<CNodeAddress> mReachableNodes = new HashSet<CNodeAddress>();
    private boolean mAlwaysRequestNodeInfo;
    private boolean mUseNodeNeighborAnnouncement;
    private boolean mIsClient;

    CRouter(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.mDirectLinks = new CDirectLinks(this.mDependencies, this);
    }

    boolean isUseNodeNeighborAnnouncement() {
        return this.mUseNodeNeighborAnnouncement;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        CNodeAddress local = CNodeAddress.getLocal();
        this.mReachableNodes.add(local);
        this.mLinkList = new CDijkstraLinkList(local);
        this.mLinkList.setListener(this);
        this.mDijkstra = new CDijkstraAlgorithm(local, this.mLinkList);
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        this.mAlwaysRequestNodeInfo = preferences.getBoolean("network.always.request.node.info", false);
        this.mUseNodeNeighborAnnouncement = preferences.getBoolean("network.node.neighbor.announcement", false);
        CNodeInfoDto localNodeInfo = this.mDependencies.getNodeInfoDatabase().getLocalNodeInfo();
        this.mIsClient = ETypeOfNode.CLIENT.equals((Object)localNodeInfo.getTypeOfNode());
        aServiceRegistry.registerService(IRouter.class, (Object)this);
        aServiceRegistry.registerService(IInternalRouter.class, (Object)this);
    }

    public void addDirectLink(@NotNull CNodeAddress aNodeAddress) throws CException {
        this.mDirectLinks.add(aNodeAddress);
        CNodeInfoDto dto = this.mDependencies.getNodeInfoDatabase().getOrCreateNodeRecord(aNodeAddress);
        this.mReachableNodes.add(aNodeAddress);
        CDijkstraLink link = new CDijkstraLink(CNodeAddress.getLocal(), aNodeAddress, ZonedDateTime.now(), 0);
        this.addLink(link);
        try {
            CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
            env.setSender(this.mTarget.getAddress());
            env.setPacketBuilderSequence("M");
            CRecord rec = CRecordNetworkNotifyUpdateNodeLinkList.create();
            if (!this.mDependencies.getClientHandlingService().isAlternateRoutingEnabled() || !this.mIsClient) {
                CRecord record = this.mLinkList.createRecordWithLinks(true, false);
                CRecordNetworkNotifyUpdateNodeLinkList.setLinks((CRecord)rec, (CRecord)record);
            }
            this.broadCast(env, rec, aNodeAddress);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error sending the links to the other node ({}).", new Object[]{aNodeAddress});
        }
        this.privateSendNotifyRemoteNodeAdded(dto);
    }

    public void addLink(@NotNull CDijkstraLink aLink) {
        this.mLinkList.addLink(aLink);
    }

    public boolean canSendMessage(@NotNull CMessage aMessage) throws CException {
        boolean shouldHaveNodeInfo;
        CNodeAddress remoteAddress = aMessage.getEnvelope().getReceiver().getNamespaceAddress().getNodeAddress();
        CNodeInfoDto remoteInfo = this.mDependencies.getNodeInfoDatabase().getOrCreateNodeRecord(remoteAddress);
        INodeInfoDatabase nodeDb = this.mDependencies.getNodeInfoDatabase();
        String pbs = nodeDb.getPacketBuilderSequence(aMessage);
        boolean bl = shouldHaveNodeInfo = this.mAlwaysRequestNodeInfo || pbs.contains("A");
        if (shouldHaveNodeInfo && !remoteInfo.isValidated()) {
            remoteInfo.saveMessage(aMessage);
            nodeDb.requestRemoteNodeInfo(remoteAddress, true);
            return false;
        }
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Nullable
    public CTargetAddress getCheapestAddress(@NotNull Collection<CTargetAddress> aAddresses) {
        CTargetAddress cheapestAddress = null;
        int cheapestAddressCosts = Integer.MAX_VALUE;
        for (CTargetAddress address : aAddresses) {
            int cumulatedCostsForNode = this.getCostsTo(address.getNamespaceAddress().getNodeAddress());
            if (cumulatedCostsForNode >= cheapestAddressCosts) continue;
            cheapestAddressCosts = cumulatedCostsForNode;
            cheapestAddress = address;
        }
        return cheapestAddress;
    }

    @Nullable
    public CNodeAddress getCheapestNode(@NotNull Collection<CNodeAddress> aNodes) {
        CNodeAddress cheapestNode = null;
        int cheapestNodeCosts = Integer.MAX_VALUE;
        for (CNodeAddress address : aNodes) {
            int cumulatedCostsForNode = this.getCostsTo(address);
            if (cumulatedCostsForNode >= cheapestNodeCosts) continue;
            cheapestNodeCosts = cumulatedCostsForNode;
            cheapestNode = address;
        }
        return cheapestNode;
    }

    public int getCostsTo(@NotNull CNodeAddress aNode) {
        CUtilCheck.checkNotNull((Object)aNode, (String)"Missing Node address", (Object[])new Object[0]);
        if (aNode.isLocalNode()) {
            return 0;
        }
        int costs = 0;
        Collection<CDijkstraLink> linkPath = this.mDijkstra.getLinkPath(aNode);
        if (linkPath != null) {
            for (CDijkstraLink link : linkPath) {
                costs += link.getCosts();
            }
        }
        return costs;
    }

    public CNodeAddress getNextNode(@NotNull CNodeAddress aDestination, boolean aUseRoutingHints) {
        CNodeId nodeId;
        CNodeAddress nextNode = this.mDijkstra.getNextNode(aDestination);
        if (nextNode == null && aUseRoutingHints && (nodeId = this.mDependencies.getRoutingHintRegistry().getBridgeNode(aDestination)) != null && !nodeId.equals((Object)CNodeId.getLocal())) {
            CNodeAddress newDestination = new CNodeAddress(nodeId, CSegmentId.getLocal());
            nextNode = this.mDijkstra.getNextNode(newDestination);
        }
        return nextNode;
    }

    @NotNull
    public Collection<CNodeInfo> getReachableNodes() {
        Collection<CNodeAddress> nodeAddresses = this.getReachableNodeAddresses();
        return this.mDependencies.getNodeInfoDatabase().getNodeInfo(nodeAddresses);
    }

    @NotNull
    public Collection<CNodeAddress> getReachableNodeAddresses() {
        CNodeAddress local = CNodeAddress.getLocal();
        Collection<CNodeAddress> nodeAddresses = this.mDijkstra.getReachableNodes();
        if (!nodeAddresses.contains(local)) {
            nodeAddresses.add(local);
        }
        return nodeAddresses;
    }

    @Override
    public void internalDeleteNodeLink(@NotNull CNodeAddress aNodeAddress1, @NotNull CNodeAddress aNodeAddress2) {
        LOG.debug("Incoming Broadcast DeletedNodeLink: delete link {}<->{}", new Object[]{aNodeAddress1, aNodeAddress2});
        this.mLinkList.removeLink(aNodeAddress1, aNodeAddress2);
    }

    @Override
    @NotNull
    public Collection<CNodeAddress> internalGetReachableNodes(@NotNull Collection<CNodeAddress> aFilter) {
        HashSet<CNodeAddress> result = new HashSet<CNodeAddress>();
        Collection<CNodeAddress> reachableNodes = this.mDijkstra.getReachableNodes();
        this.privateFilterNodeIds(reachableNodes, result, aFilter);
        return result;
    }

    @Override
    @NotNull
    public Collection<CNodeAddress> internalGetUnreachableNodes(@NotNull Collection<CNodeAddress> aFilter) {
        HashSet<CNodeAddress> result = new HashSet<CNodeAddress>();
        Collection<CNodeAddress> reachableNodes = this.mDijkstra.getUnreachableNodes();
        this.privateFilterNodeIds(reachableNodes, result, aFilter);
        return result;
    }

    @Override
    public void internalIncomingNodeLinkList(@NotNull CRecord aRecord) throws CException {
        this.privateIncomingBroadcastNodeLinks(aRecord);
        if (this.mAlwaysRequestNodeInfo) {
            CNodeAddress[] nodeAddresses = CRecordNetworkLinkList.getNodeAddresses((CRecord)aRecord, null);
            this.privateCheckNodeRecords(nodeAddresses);
        }
        this.mDependencies.getNodeInfoDatabase().processPendingAnswers();
    }

    @Override
    public void internalSetTarget(@Nullable ITarget aTarget) {
        this.mTarget = aTarget;
    }

    @Override
    public void updateDirectLinksForRemoteNode(@NotNull CNodeAddress aNode, @Nullable CRecord[] aDirectLinks) {
        Collection<CDijkstraNeighbor> neighbors = this.mLinkList.getNeighbors(aNode);
        INodeInfoDatabase nodeDb = this.mDependencies.getNodeInfoDatabase();
        for (CRecord link : aDirectLinks) {
            CNodeInfoDto dto;
            if (link == null || (dto = CNodeInfoDto.fromRecord((CRecord)link)) == null) continue;
            nodeDb.updateNodeInfo(dto);
            CNodeAddress nodeAddress = dto.getNodeAddress();
            CDijkstraLink link2 = new CDijkstraLink(aNode, nodeAddress, dto.getTimestampCreation(), 1);
            this.mLinkList.addLink(link2);
            neighbors.removeIf(n -> n.getNodeAddress().equals((Object)nodeAddress));
        }
        for (CDijkstraNeighbor neighbor : neighbors) {
            this.mLinkList.removeLink(aNode, neighbor.getNodeAddress());
        }
    }

    public boolean isReachable(@NotNull CNodeAddress aNode) {
        if (aNode.isLocalNode()) {
            return true;
        }
        return this.mDijkstra.isReachable(aNode);
    }

    @Override
    public void notifyLinkListUpdated() {
        this.mDijkstra.update(this.mLinkList);
        this.privateUpdateReachableNodes();
    }

    @Override
    public void notifyNodeAdded(@NotNull CNodeAddress aNodeAddress) {
        this.mDependencies.getNodeInfoDatabase().getOrCreateNodeRecord(aNodeAddress);
    }

    void broadCast(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, @Nullable CNodeAddress aPosFilter) throws CException {
        if (this.mTarget != null) {
            aEnvelope.setSender(this.mTarget.getAddress());
            CMessage msgToSend = new CMessage(aEnvelope, aRecord);
            CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeAddress)CNodeAddress.getLocal());
            CRecord rec = CRecordBroadcastSendMsg.create();
            CRecordBroadcastSendMsg.setLocally((CRecord)rec, (boolean)false);
            CRecordBroadcastSendMsg.setMessage((CRecord)rec, (CMessage)msgToSend);
            if (aPosFilter != null) {
                CNodeAddress[] arr = new CNodeAddress[]{aPosFilter};
                CRecordBroadcastSendMsg.setPositiveFilter((CRecord)rec, (CNodeAddress[])arr);
            }
            this.mTarget.send(env, rec);
        }
    }

    private void privateCheckNodeRecord(@Nullable CNodeAddress aNodeAddress) throws CException {
        if (aNodeAddress != null && !aNodeAddress.isLocalNode()) {
            INodeInfoDatabase nodeDb = this.mDependencies.getNodeInfoDatabase();
            nodeDb.requestRemoteNodeInfo(aNodeAddress, false);
        }
    }

    private void privateCheckNodeRecords(@Nullable CNodeAddress[] aNodeArray) throws CException {
        if (aNodeArray != null) {
            for (CNodeAddress node : aNodeArray) {
                this.privateCheckNodeRecord(node);
            }
        }
    }

    private void privateFilterNodeIds(@NotNull Collection<CNodeAddress> aSource, @NotNull Collection<CNodeAddress> aDestination, @NotNull Collection<CNodeAddress> aFilter) {
        for (CNodeAddress adr : aSource) {
            if (!aFilter.isEmpty()) {
                boolean found = false;
                for (CNodeAddress filter : aFilter) {
                    if (!adr.equals((Object)filter)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            aDestination.add(adr);
        }
    }

    private void privateIncomingBroadcastNodeLinks(@NotNull CRecord aRecord) throws CException {
        List<CDijkstraLink> links = CUtilLinkList.fromRecord(aRecord);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(250 + links.size() * 50);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("| Incoming Broadcast NodeLinkList: (local=");
            sb.append(CNodeAddress.getLocal());
            sb.append(")\n");
            for (CDijkstraLink link : links) {
                sb.append("|  ");
                sb.append(link.toString());
                sb.append("\n");
            }
            sb.append(CUtilString.LINE);
            LOG.debug(sb.toString());
        }
        this.updateLinks(links);
    }

    private void privateRemoveLink(@NotNull CNodeAddress aNode1, @NotNull CNodeAddress aNode2) {
        this.mLinkList.removeLink(aNode1, aNode2);
    }

    private void privateSendDeletedNodeLink(@NotNull CNodeAddress aNode1, @NotNull CNodeAddress aNode2) {
        LOG.debug("broadcast DeletedNodeLink {}<->{}", new Object[]{aNode1, aNode2});
        if (this.mTarget != null) {
            try {
                CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
                env.setSender(this.mTarget.getAddress());
                CRecord rec = CRecordNetworkNotifyNodeLinkDeleted.create();
                CRecordNetworkNotifyNodeLinkDeleted.setNode1((CRecord)rec, (CNodeAddress)aNode1);
                CRecordNetworkNotifyNodeLinkDeleted.setNode2((CRecord)rec, (CNodeAddress)aNode2);
                this.broadCast(env, rec, null);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Error sending broadcast (deleted node link).");
            }
        }
    }

    private void privateSendNotifyRemoteNodeRemoved(@NotNull CNodeAddress aRemoteNode) throws CException {
        INodeInfoDatabase nodeInfoDatabase = this.mDependencies.getNodeInfoDatabase();
        CNodeInfoDto nodeInfo = nodeInfoDatabase.getNodeInfo(aRemoteNode);
        if (nodeInfo != null) {
            nodeInfoDatabase.sendNotifyRemoteNodeRemoved(nodeInfo);
        }
    }

    private void privateSendNotifyRemoteNodeAdded(@NotNull CNodeInfoDto aRemoteNode) throws CException {
        INodeInfoDatabase nodeInfoDatabase = this.mDependencies.getNodeInfoDatabase();
        nodeInfoDatabase.sendNotifyRemoteNodeAdded(aRemoteNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateUpdateReachableNodes() {
        INodeInfoDatabase nodeDb = this.mDependencies.getNodeInfoDatabase();
        Collection<CNodeAddress> nodes = this.mDijkstra.getReachableNodes();
        HashSet<CNodeAddress> set = new HashSet<CNodeAddress>(nodes);
        Boolean bl = this.mReachableNodesMutex;
        synchronized (bl) {
            Set<CNodeAddress> oldReachableNodes = this.mReachableNodes;
            this.mReachableNodes = set;
            for (CNodeAddress node : oldReachableNodes) {
                if (this.mReachableNodes.contains(node)) continue;
                try {
                    this.privateSendNotifyRemoteNodeRemoved(node);
                }
                catch (CException e) {
                    LOG.error("Couldn't send CNotifyRemoteNodeIdRemoved for {}.", new Object[]{node});
                }
            }
            for (CNodeAddress node : this.mReachableNodes) {
                if (oldReachableNodes.contains(node)) continue;
                try {
                    CNodeInfoDto dto = nodeDb.getOrCreateNodeRecord(node);
                    this.privateSendNotifyRemoteNodeAdded(dto);
                }
                catch (CException e) {
                    LOG.error("Couldn't send CNotifyRemoteNodeIdAdded for {}.", new Object[]{node});
                }
            }
        }
    }

    public void removeDirectLink(@NotNull CNodeAddress aLocalNode, @NotNull CNodeAddress aRemoteNode) throws CException {
        this.mDirectLinks.remove(aRemoteNode);
        if (this.mLinkList.removeLink(aLocalNode, aRemoteNode)) {
            this.privateSendDeletedNodeLink(aLocalNode, aRemoteNode);
        }
    }

    @NotNull
    public Collection<CNodeAddress> getDirectLinks(boolean aOnlyClients) {
        return this.mDirectLinks.getList(aOnlyClients);
    }

    public void renewNodeRecord(@NotNull CNodeAddress aRemoteNode) throws CException {
        LOG.debug("Request RenewNodeRecord to {}.", new Object[]{aRemoteNode});
        if (this.mTarget != null) {
            CEnvelope env = CEnvelope.forSingleTarget((IId)CWellKnownTID.ROUTER, (IId)CWellKnownNID.TRANSPORT, (CNodeAddress)aRemoteNode);
            env.setRawTransport();
            CRecord rec = CRecordNetworkRenewNodeRecord.create();
            this.mTarget.send(env, rec);
        }
    }

    public void updateLinks(@NotNull Collection<CDijkstraLink> aLinks) {
        this.mLinkList.updateLinks(aLinks);
    }

    public boolean isNeighbor(@NotNull CNodeAddress aNode) {
        return this.mDirectLinks.isNeighbor(aNode);
    }

    @Override
    public List<CDijkstraLink> internalGetLinkList() {
        return this.mLinkList.getLinkList();
    }

    @Override
    public void internalUpdateCosts(@NotNull CRecord aLinks) throws CException {
        List<CDijkstraLink> links = CUtilLinkList.fromRecord(aLinks);
        for (CDijkstraLink link : links) {
            this.mLinkList.updateCosts(link);
        }
    }
}

