/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.impl.network.router.CDijkstraNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

final class CDijkstraNodeList {
    private final Map<CNodeAddress, CDijkstraNode> mNodes;
    private final CNodeAddress mLocalNodeId;

    CDijkstraNodeList(CNodeAddress aLocalNodeId) {
        this.mLocalNodeId = aLocalNodeId;
        this.mNodes = new HashMap<CNodeAddress, CDijkstraNode>();
    }

    void add(CNodeAddress aNodeId) {
        if (!this.mNodes.containsKey(aNodeId)) {
            this.mNodes.put(aNodeId, new CDijkstraNode(aNodeId));
        }
    }

    CDijkstraNode findUnsettledNodeWithMinimumCosts() {
        CDijkstraNode minNode = null;
        for (CDijkstraNode node : this.mNodes.values()) {
            if (node.isSettled() || minNode != null && node.getTotalCosts() >= minNode.getTotalCosts()) continue;
            minNode = node;
        }
        return minNode;
    }

    CDijkstraNode get(CNodeAddress aNodeId) {
        return this.mNodes.get(aNodeId);
    }

    LinkedList<CNodeAddress> getPath(CNodeAddress aTarget) {
        LinkedList<CNodeAddress> path = new LinkedList<CNodeAddress>();
        CNodeAddress step = aTarget;
        while (step != null) {
            path.addFirst(step);
            step = this.mNodes.get(step).getPrevious();
        }
        if (path.size() <= 1) {
            path.clear();
        }
        return path;
    }

    CNodeAddress[] getReachableNodeIdArray() {
        CNodeAddress[] nodeIdArray;
        Collection<CDijkstraNode> nodes = this.getReachableNodes();
        int size = nodes.size();
        if (size == 0) {
            nodeIdArray = new CNodeAddress[]{this.mLocalNodeId};
        } else {
            nodeIdArray = new CNodeAddress[size];
            int i = 0;
            for (CDijkstraNode node : nodes) {
                nodeIdArray[i++] = node.getNodeId();
            }
        }
        return nodeIdArray;
    }

    Collection<CNodeAddress> getReachableNodeIds() {
        HashSet<CNodeAddress> result = new HashSet<CNodeAddress>();
        for (CDijkstraNode node : this.mNodes.values()) {
            if (!node.isSettled()) continue;
            result.add(node.getNodeId());
        }
        result.add(this.mLocalNodeId);
        return result;
    }

    private Collection<CDijkstraNode> getReachableNodes() {
        HashSet<CDijkstraNode> result = new HashSet<CDijkstraNode>();
        for (CDijkstraNode node : this.mNodes.values()) {
            if (!node.isSettled()) continue;
            result.add(node);
        }
        return result;
    }

    Collection<CNodeAddress> getUnreachableNodeIds() {
        HashSet<CNodeAddress> result = new HashSet<CNodeAddress>();
        for (CDijkstraNode node : this.mNodes.values()) {
            if (node.isUnSettled() || node.isSettled()) continue;
            result.add(node.getNodeId());
        }
        return result;
    }

    Collection<CDijkstraNode> getUnreachableNodes() {
        HashSet<CDijkstraNode> result = new HashSet<CDijkstraNode>();
        for (CDijkstraNode node : this.mNodes.values()) {
            if (node.isUnSettled() || node.isSettled()) continue;
            result.add(node);
        }
        return result;
    }

    int getUnsettledCount() {
        int count = 0;
        for (CDijkstraNode node : this.mNodes.values()) {
            if (!node.isUnSettled()) continue;
            ++count;
        }
        return count;
    }

    boolean isEmpty() {
        return this.mNodes.isEmpty();
    }

    void reset() {
        for (CDijkstraNode node : this.mNodes.values()) {
            node.reset();
        }
    }
}

