/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.nodeinfo;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.nodes.CKeyHelper;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordDataNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;

public class CNodeInfoUtil {
    private CNodeInfoUtil() {
    }

    @NotNull
    public static CRecord createRecord(@NotNull CNodeInfoDto aDto) throws CException {
        CRecord record = CRecordDataNodeInfo.create();
        aDto.toRecord(record);
        return record;
    }

    public static void requestRecord(@NotNull CNodeInfoDto aDto) {
        aDto.setTimestampNodeRecordRequested(System.currentTimeMillis());
    }

    public static SecretKey getMySessionKey(@NotNull CNodeInfoDto aDto) {
        SecretKey mySessionKey = aDto.getMySessionKey();
        if (mySessionKey == null) {
            mySessionKey = CKeyHelper.createSessionKey();
            aDto.setMySessionKey(mySessionKey);
        }
        return mySessionKey;
    }

    @NotNull
    public static List<CMessage> fetchMessages(@NotNull CNodeInfoDto aDto) {
        List mm = aDto.getPendingMessages();
        if (mm == null) {
            return Collections.emptyList();
        }
        aDto.setPendingMessages(null);
        return mm;
    }
}

