/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.costs;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.costs.CCostList;
import de.sillysky.nyssr.impl.network.costs.IDependencies;
import de.sillysky.nyssr.impl.network.costs.records.CRecordAddNewLocalLinkCost;
import de.sillysky.nyssr.impl.network.costs.records.CRecordTimer;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.link.cost.collector.CConstantsLinkCostCollector;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordAddLinkCosts;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CLocalLinkCostCollector
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private final IDependencies mDependencies;
    private final CCostList mCostList = new CCostList();
    private long mTimeout = 50L;
    private CTimer mTimer;
    private CTargetAddress mNetworkLinkCostCollector;

    CLocalLinkCostCollector(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAddNewLocalLinkCost.ID, this::asyncAddLocalLinkCosts);
        this.addMessageHandler(CRecordTimer.ID, this::asyncTimer);
        this.addMessageHandler(CRecordAddLinkCosts.ID, this::asyncAnswerAddLinkCosts);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        this.mTimeout = preferences.getLong("network.timout.sending.local.costs.in.seconds", 50L);
        INamespace ns = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.TRANSPORT);
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mTimer.dismiss();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        INamespace system = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        system.getNanoServiceRegistry().addNanoServiceAndObserver(CRecordAddNewLocalLinkCost.class, this.getAddress(), false);
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), CRecordTimer.ID, this.getAddress(), this.mTimeout * 1000L, false, null);
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddLocalLinkCosts(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeId nodeId = CRecordAddNewLocalLinkCost.getNodeId(aRecord, null);
        int costs = CRecordAddNewLocalLinkCost.getCosts(aRecord, 0);
        this.mCostList.add(nodeId, costs);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTimer.notifyTriggerOccurred();
        this.sendCosts();
        this.mTimer.startIfElseReset();
        return true;
    }

    private boolean asyncAnswerAddLinkCosts(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                this.mNetworkLinkCostCollector = aEnvelope.getSender();
                LOG.debug("Got address from micro service LinkCostCollector: {}", new Object[]{this.mNetworkLinkCostCollector});
            }
            return true;
        }
        return false;
    }

    private void sendCosts() throws CException {
        CRecord record = this.mCostList.toRecord();
        if (record != null) {
            if (this.mNetworkLinkCostCollector == null) {
                CEnvelope env = CEnvelope.forMicroService((IId)CConstantsLinkCostCollector.MICRO_SERVICE_ID);
                this.sendRequest(env, record);
            } else {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mNetworkLinkCostCollector);
                this.sendNotification(env, record);
            }
        }
    }
}

