/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWidgetSetList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetSetList.class);
    private final Map<CWidgetSetId, CWidgetSet> mWidgetSets = new HashMap<CWidgetSetId, CWidgetSet>();

    CWidgetSetList() {
    }

    void add(@NotNull CWidgetSet aWidgetSet) {
        CWidgetSetId id = aWidgetSet.getId();
        LOG.debug("Add WidgetSet {}", new Object[]{id});
        this.mWidgetSets.put(id, aWidgetSet);
    }

    CWidget findWidget(@NotNull CWidgetId aWidgetId) {
        CWidgetSet ws = this.get(aWidgetId.getWidgetSetId());
        if (ws != null) {
            return ws.findWidget(aWidgetId);
        }
        return null;
    }

    CWidget findWidget(@NotNull CWidgetSetId aWidgetSetId, @NotNull String aWidgetId) {
        CWidgetSet ws = this.get(aWidgetSetId);
        if (ws != null) {
            return ws.findWidget(aWidgetId);
        }
        return null;
    }

    CWidgetSet get(CWidgetSetId aId) {
        return this.mWidgetSets.get(aId);
    }

    CWidget getRootWidget(CWidgetSetId aWidgetSetId) {
        CWidgetSet set = this.get(aWidgetSetId);
        if (set == null) {
            return null;
        }
        return set.getRootWidget();
    }

    private boolean isOnline(@NotNull CWidgetSet aWidgetSet) {
        return this.mWidgetSets.containsKey(aWidgetSet.getId());
    }

    void notifyWidgetUnmounted(@NotNull CWidget aWidget) {
        CWidgetSet widgetSet = aWidget.getWidgetSet();
        if (this.isOnline(widgetSet) && widgetSet.isRootWidget(aWidget)) {
            this.mWidgetSets.remove(widgetSet.getId());
        }
    }

    @Nullable
    public CWidget findComponent(@NotNull Component aComponent) {
        for (CWidgetSet set : this.mWidgetSets.values()) {
            CWidget widget = set.findComponent(aComponent);
            if (widget == null) continue;
            return widget;
        }
        return null;
    }

    public void dump(@Nullable String aFilter) {
        StringBuilder sb = new StringBuilder(2000);
        sb.append(CUtilString.LINE_CRLF);
        for (CWidgetSet set : this.mWidgetSets.values()) {
            sb.append(set.getId()).append(CUtilString.CRLF);
            CWidgetList list = set.getWidgets();
            list.dump(sb, 1, aFilter);
        }
        sb.append(CUtilString.LINE_CRLF);
        System.out.println(sb);
    }
}

