/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.vars;

import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyHolder;
import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyListener;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CGlobalPropertyHolder
implements IService,
IGlobalPropertyHolder {
    private final Map<String, Object> mProperties = new ConcurrentHashMap<String, Object>();
    private final Set<IGlobalPropertyListener> mListeners = new CopyOnWriteArraySet<IGlobalPropertyListener>();

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IGlobalPropertyHolder.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public void addVar(@NotNull String aKey, @Nullable Object aValue) {
        Object value;
        String key = this.makeKey(aKey);
        if (!(key == null || (value = this.mProperties.get(key)) != null && value.equals(aValue))) {
            this.mProperties.put(key, aValue);
            this.informListeners(aKey, aValue);
        }
    }

    @Nullable
    public Object get(@NotNull String aKey) {
        String key = this.makeKey(aKey);
        if (key != null) {
            return this.mProperties.get(key);
        }
        return null;
    }

    @NotNull
    public Properties getAll() {
        Properties sp = new Properties();
        for (Map.Entry<String, Object> e : this.mProperties.entrySet()) {
            Object v1 = e.getValue();
            Object v2 = v1 == null ? "" : v1;
            sp.put(e.getKey(), v2);
        }
        return sp;
    }

    @Nullable
    public Object remove(@NotNull String aKey) {
        String key = this.makeKey(aKey);
        if (key != null) {
            return this.mProperties.remove(key);
        }
        return null;
    }

    public void addListener(@NotNull IGlobalPropertyListener aListener) {
        this.mListeners.add(aListener);
    }

    public void removeListener(@NotNull IGlobalPropertyListener aListener) {
        this.mListeners.remove(aListener);
    }

    @Nullable
    private String makeKey(@Nullable String aKey) {
        if (aKey == null) {
            return null;
        }
        String s = aKey.trim().toLowerCase();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    private void informListeners(@NotNull String aKey, @Nullable Object aValue) {
        for (IGlobalPropertyListener l : this.mListeners) {
            try {
                l.notifyChanged(aKey, aValue);
            }
            catch (Exception exception) {}
        }
    }
}

