/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.connector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.remoteskin.server.connector.CRemoteSkinClientContextEntry;
import de.sillysky.nyssr.impl.remoteskin.server.connector.CRemoteSkinClientContextList;
import de.sillysky.nyssr.impl.remoteskin.server.connector.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinConnector;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContextListener;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStartContext;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStopContext;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStoreWidgetSets;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinConnector
extends CTarget
implements IRemoteSkinConnector,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinConnector.class);
    private final CRemoteSkinClientContextList mContextList = new CRemoteSkinClientContextList();
    private final Map<UUID, CListener> mListener = new HashMap<UUID, CListener>();
    private final IDependencies mDependencies;

    CRemoteSkinConnector(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoteSkinStartContext.ID, this::asyncAnswerStartContext);
        this.addMessageHandler(CRecordRemoteSkinStopContext.ID, this::asyncAnswerStopContext);
        this.addMessageHandler(CRecordRemoteSkinStoreWidgetSets.ID, this::asyncAnswerStoreWidgetSets);
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        ns.getTargetRegistry().registerTarget((ITarget)this);
        aServiceRegistry.registerService(IRemoteSkinConnector.class, (Object)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerStartContext(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            IId contextId = CRecordRemoteSkinStartContext.getContextId((CRecord)aRecord, null);
            CRemoteSkinClientContextEntry entry = this.mContextList.get(contextId);
            if (entry != null) {
                int code = aEnvelope.getResultCode();
                if (code != 0) {
                    String resultText = aEnvelope.getResultText();
                    LOG.error("Error starting RemoteSkin Client Context {}: {} - {}", new Object[]{contextId, code, resultText});
                    this.informListener(aEnvelope.getTransactionId(), code, resultText);
                    this.mContextList.remove(contextId);
                } else {
                    CTargetAddress address = CRecordRemoteSkinStartContext.getContextAddress((CRecord)aRecord, null);
                    entry.setTargetAddress(address);
                    LOG.debug("RemoteSkin Client Context {} successfully created: address = {}", new Object[]{contextId, address});
                    this.informListener(aEnvelope.getTransactionId(), 0, "");
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncAnswerStopContext(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            IId contextId = CRecordRemoteSkinStartContext.getContextId((CRecord)aRecord, null);
            int code = aEnvelope.getResultCode();
            if (code != 0) {
                LOG.error("Error stopping RemoteSkin Client Context {}: {} - {}", new Object[]{contextId, code, aEnvelope.getResultText()});
            } else {
                this.informListener(aEnvelope.getTransactionId(), 0, "");
            }
            this.mContextList.remove(contextId);
            return true;
        }
        return false;
    }

    private void informListener(@Nullable UUID aTransactionId, int aResultCode, @NotNull String aResultText) {
        CListener listener;
        if (aTransactionId != null && (listener = this.mListener.get(aTransactionId)) != null) {
            try {
                listener.getListener().notify(listener.getEntry(), aResultCode, aResultText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean asyncAnswerStoreWidgetSets(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            UUID transactionId = aEnvelope.getTransactionId();
            if (transactionId != null) {
                this.informListener(aEnvelope.getTransactionId(), aEnvelope.getResultCode(), aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    public void startContext(@NotNull IId aContextId, @NotNull CNodeAddress aNodeAddress, @NotNull String aPlatformType, @Nullable IRemoteSkinServerContextListener aListener) throws CException {
        CRemoteSkinClientContextEntry clientContext = this.mContextList.get(aContextId);
        if (clientContext != null) {
            LOG.warn("Couldn't start RemoteSkin Client Context {}: already started", new Object[]{aContextId});
            return;
        }
        LOG.debug("Start RemoteSkin Client Context {}", new Object[]{aContextId});
        clientContext = new CRemoteSkinClientContextEntry(aContextId, aNodeAddress, aPlatformType);
        this.mContextList.add(clientContext);
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordRemoteSkinStartContext.class, (CNodeAddress)aNodeAddress);
        this.saveListener(clientContext, aListener, env);
        CRecord record = CRecordRemoteSkinStartContext.create();
        CRecordRemoteSkinStartContext.setContextId((CRecord)record, (IId)aContextId);
        CRecordRemoteSkinStartContext.setPlatform((CRecord)record, (String)aPlatformType);
        this.sendRequest(env, record);
    }

    public boolean stopContext(@NotNull IId aContextId, @Nullable IRemoteSkinServerContextListener aListener) throws CException {
        CRemoteSkinClientContextEntry clientContext = this.mContextList.get(aContextId);
        if (clientContext == null) {
            LOG.warn("Couldn't stop RemoteSkin Client Context {}: unknown", new Object[]{aContextId});
            return false;
        }
        CTargetAddress targetAddress = clientContext.getTargetAddress();
        if (targetAddress == null) {
            LOG.warn("Couldn't stop RemoteSkin Client Context {}: no target address known", new Object[]{aContextId});
            return false;
        }
        LOG.debug("Stop RemoteSkin Client Context {}", new Object[]{aContextId});
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordRemoteSkinStopContext.class, (CNodeAddress)targetAddress.getNodeAddress());
        this.saveListener(clientContext, aListener, env);
        CRecord record = CRecordRemoteSkinStopContext.create();
        CRecordRemoteSkinStopContext.setContextId((CRecord)record, (IId)aContextId);
        this.sendRequest(env, record);
        return true;
    }

    public void addContext(@NotNull IId aContextId, @NotNull CTargetAddress aContextAddress, @NotNull String aPlatformType) {
        CRemoteSkinClientContextEntry clientContext = this.mContextList.get(aContextId);
        if (clientContext != null) {
            return;
        }
        clientContext = new CRemoteSkinClientContextEntry(aContextId, aContextAddress.getNodeAddress(), aPlatformType);
        clientContext.setTargetAddress(aContextAddress);
        this.mContextList.add(clientContext);
    }

    private void saveListener(@NotNull IRemoteSkinClientContext aEntry, @Nullable IRemoteSkinServerContextListener aListener, @NotNull CEnvelope aEnvelope) {
        if (aListener != null) {
            UUID transactionId = CUtilUuid.random();
            aEnvelope.setTransactionId(transactionId);
            this.mListener.put(transactionId, new CListener(aEntry, aListener));
        }
    }

    public boolean pushWidgetSets(@NotNull IId aContextId, @NotNull List<String> aJson, @Nullable IRemoteSkinServerContextListener aListener) throws CException {
        CRemoteSkinClientContextEntry clientContext = this.mContextList.get(aContextId);
        if (clientContext == null) {
            LOG.warn("Couldn't send WidgetSets to RemoteSkin Client Context {}: Client Context is null", new Object[]{aContextId});
            return false;
        }
        CTargetAddress targetAddress = clientContext.getTargetAddress();
        if (targetAddress == null) {
            LOG.warn("Couldn't send WidgetSets to RemoteSkin Client Context {}: no target address known", new Object[]{aContextId});
            return false;
        }
        LOG.debug("Send {} WidgetsSets to RemoteSkin Client Context ID={}", new Object[]{aJson.size(), aContextId});
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)targetAddress);
        this.saveListener(clientContext, aListener, env);
        CRecord rec = CRecordRemoteSkinStoreWidgetSets.create();
        String[] arr = aJson.toArray(new String[0]);
        CRecordRemoteSkinStoreWidgetSets.setWidgetSets((CRecord)rec, (String[])arr);
        this.sendRequest(env, rec);
        return true;
    }

    private static class CListener {
        private final IRemoteSkinClientContext mEntry;
        private final IRemoteSkinServerContextListener mListener;

        private CListener(IRemoteSkinClientContext aEntry, IRemoteSkinServerContextListener aListener) {
            this.mEntry = aEntry;
            this.mListener = aListener;
        }

        public IRemoteSkinClientContext getEntry() {
            return this.mEntry;
        }

        public IRemoteSkinServerContextListener getListener() {
            return this.mListener;
        }
    }
}

