/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.platform.registry;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinPlatformContext;
import de.sillysky.nyssr.remoteskin.model.platform.IRemoteSkinPlatformRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class CRemoteSkinPlatformRegistry
implements IRemoteSkinPlatformRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinPlatformRegistry.class);
    private final Map<String, IRemoteSkinPlatformContext> mPlatforms = new ConcurrentHashMap<String, IRemoteSkinPlatformContext>();

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Activate {}", new Object[]{this.getClass().getSimpleName()});
        aServiceRegistry.registerService(IRemoteSkinPlatformRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Deactivate {}", new Object[]{this.getClass().getSimpleName()});
        aServiceRegistry.deregisterService((Object)this);
    }

    public void deregisterPlatform(@NotNull String aType) {
        LOG.info("Deregister RemoteSkin Platform {}", new Object[]{aType});
        this.mPlatforms.remove(aType);
    }

    public IRemoteSkinPlatformContext getPlatform(@NotNull String aType) {
        return this.mPlatforms.get(aType);
    }

    public void registerPlatform(@NotNull String aType, @NotNull IRemoteSkinPlatformContext aPlatform) {
        LOG.info("Register RemoteSkin Platform {}", new Object[]{aType});
        this.mPlatforms.put(aType, aPlatform);
    }
}

