/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.broadcast.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordBroadcastTransportMsg
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"79e8304a-b6bb-4fc5-9acb-d8f930017ec0");
    public static final String NAME = "BroadcastTransportMsg";
    public static final String DESCRIPTION = "Transport message to carry Broadcast Messages per flooding to other nodes.";
    public static final String SLOT_BROADCAST_ID = "2";
    public static final String SLOT_MESSAGE = "3";
    public static final String SLOT_SOURCE = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getBroadcastId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_BROADCAST_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CMessage getMessage(@NotNull CRecord aRecord, CMessage aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (CMessage)slot.getValue();
    }

    public static CTargetAddress getSource(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SOURCE);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setBroadcastId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_BROADCAST_ID, slot);
    }

    public static void setMessage(@NotNull CRecord aRecord, CMessage aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.MESSAGE, (Object)aValue);
        aRecord.addSlot(SLOT_MESSAGE, slot);
    }

    public static void setSource(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_SOURCE, slot);
    }
}

