/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.ping;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.ping.CTargetLinkCosts;
import de.sillysky.nyssr.impl.network.ping.ILinkCostTargetFactory;
import de.sillysky.nyssr.impl.network.ping.ITargetLinkCosts;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.packets.IPacketContext;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CLinkCostFactory
implements IService,
ILinkCostTargetFactory {
    private INamespaceFactory mNamespaceFactory;
    private ITimerManager mTimerManager;

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
        aServiceRegistry.registerService(ILinkCostTargetFactory.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public ITargetLinkCosts createTarget(@NotNull IPacketContext aPacketContext) throws CException {
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "Transport");
        CTargetLinkCosts tgt = new CTargetLinkCosts(this.mTimerManager, aPacketContext);
        ns.getTargetRegistry().registerTarget((ITarget)tgt);
        return tgt;
    }
}

