/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.network.index.EAction;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CDtoAppListener {
    private final CTargetAddress mListener;
    private final UUID mApplicationId;
    private final CStringProperties mProperties;
    private final EAction mAction;
    private boolean mTransferred = false;

    CDtoAppListener(@NotNull CTargetAddress aListener, @Nullable UUID aApplicationId, @Nullable CStringProperties aProperties, @NotNull EAction aAction) {
        this.mListener = aListener;
        this.mApplicationId = aApplicationId;
        this.mProperties = aProperties;
        this.mAction = aAction;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CDtoAppListener that = (CDtoAppListener)aO;
        if (!this.mListener.equals((Object)that.mListener)) {
            return false;
        }
        if (!Objects.equals(this.mApplicationId, that.mApplicationId)) {
            return false;
        }
        if (!Objects.equals(this.mProperties, that.mProperties)) {
            return false;
        }
        return this.mAction == that.mAction;
    }

    @NotNull
    public EAction getAction() {
        return this.mAction;
    }

    @Nullable
    public UUID getApplicationId() {
        return this.mApplicationId;
    }

    @NotNull
    public CTargetAddress getListener() {
        return this.mListener;
    }

    @Nullable
    public CStringProperties getProperties() {
        return this.mProperties;
    }

    public int hashCode() {
        int result = this.mListener.hashCode();
        result = 31 * result + (this.mApplicationId != null ? this.mApplicationId.hashCode() : 0);
        result = 31 * result + (this.mProperties != null ? this.mProperties.hashCode() : 0);
        result = 31 * result + this.mAction.hashCode();
        return result;
    }

    public boolean isTransferred() {
        return this.mTransferred;
    }

    public void setTransferred(boolean aTransferred) {
        this.mTransferred = aTransferred;
    }
}

