/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.tcp;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.tcp.CTcpConnection;
import de.sillysky.nyssr.util.tcp.ITcpOwner;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class CTcpServer
implements Runnable {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpServer.class);
    private final CopyOnWriteArrayList<CTcpConnection> mConnections = new CopyOnWriteArrayList();
    private final ITcpOwner mOwner;
    private final AtomicBoolean mStop = new AtomicBoolean();
    private final int mPort;
    private boolean mRunning = false;
    private final ServerSocket mServerSocket;
    private final int mInputBufferSize;

    public CTcpServer(@NotNull ITcpOwner aOwner, int aPort, int aBufferSize) throws Exception {
        this.mOwner = aOwner;
        this.mPort = aPort;
        this.mInputBufferSize = aBufferSize;
        LOG.info("Start creating socket on port {}.", this.mPort);
        this.mServerSocket = new ServerSocket(this.mPort);
        this.mStop.set(false);
        Thread thread = new Thread((Runnable)this, this.mOwner.getName() + "Server-" + this.mPort);
        thread.start();
        LOG.info("Okay: Socket created on port {}.", this.mPort);
    }

    @Override
    public void run() {
        LOG.info("Start: TCP server thread on port {}.", this.mPort);
        this.mRunning = true;
        while (!this.mStop.get()) {
            try {
                Socket clientSocket = this.mServerSocket.accept();
                CTcpConnection connection = new CTcpConnection(this.mOwner, this.mInputBufferSize, clientSocket);
                this.mConnections.add(connection);
            }
            catch (SocketException e) {
                LOG.debug("Okay: Socket on port {} closed.", this.mPort);
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Exception on server accept or creating connection target, port=" + this.mPort);
            }
        }
        this.mRunning = false;
    }

    public void close() {
        this.mStop.set(true);
        if (!this.mServerSocket.isClosed()) {
            LOG.debug(this.mOwner.getName() + "Start: closing socket on port {}.", this.mPort);
            try {
                this.mServerSocket.close();
                LOG.debug(this.mOwner.getName() + "Okay: socket on port {} closed.", this.mPort);
            }
            catch (IOException e) {
                LOG.error(this.mOwner.getName() + "Exception on closing server socket on port {}.", this.mPort);
            }
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void notifyClosed(@NotNull CTcpConnection aConnection) {
        this.mConnections.remove(aConnection);
    }

    public void dismiss() {
        for (CTcpConnection connection : this.mConnections) {
            connection.close();
        }
        this.mConnections.clear();
    }
}

