/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.key;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilNormalize {
    private CUtilNormalize() {
    }

    public static boolean equals(@Nullable String aString1, @Nullable String aString2) {
        if (aString1 == null && aString2 == null) {
            return true;
        }
        if (aString1 == null || aString2 == null) {
            return false;
        }
        String s1 = CUtilNormalize.normalize(aString1);
        String s2 = CUtilNormalize.normalize(aString2);
        return s1.equals(s2);
    }

    @NotNull
    public static String normalize(@Nullable String aKey) {
        if (aKey == null) {
            return "";
        }
        char[] chars = aKey.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length + 10);
        char[] cArray = chars;
        int n = cArray.length;
        block7: for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            switch (c.charValue()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '-': 
                case '/': 
                case ';': 
                case '\\': 
                case '_': {
                    continue block7;
                }
                case '\u00df': {
                    sb.append("ss");
                    continue block7;
                }
                case '\u00e4': {
                    sb.append("ae");
                    continue block7;
                }
                case '\u00fc': {
                    sb.append("ue");
                    continue block7;
                }
                case '\u00f6': {
                    sb.append("oe");
                    continue block7;
                }
                default: {
                    if (Character.isDigit(c.charValue()) || c.charValue() == '.') {
                        sb.append(c);
                        continue block7;
                    }
                    if (!Character.isLetter(c.charValue())) continue block7;
                    sb.append(Character.toLowerCase(c.charValue()));
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    public static String normalizePreference(@Nullable String aKey) {
        if (aKey == null) {
            return "";
        }
        boolean onlyUpper = CUtilNormalize.hasOnlyUpperCaseLetters(aKey);
        char[] chars = aKey.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length + 20);
        char[] cArray = chars;
        int n = cArray.length;
        block9: for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            switch (c.charValue()) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break block9;
                }
                case ' ': 
                case '/': 
                case ';': 
                case '\\': {
                    continue block9;
                }
                case '-': 
                case '_': {
                    sb.append(".");
                    continue block9;
                }
                case '\u00df': {
                    sb.append("ss");
                    continue block9;
                }
                case '\u00e4': {
                    sb.append("ae");
                    continue block9;
                }
                case '\u00fc': {
                    sb.append("ue");
                    continue block9;
                }
                case '\u00f6': {
                    sb.append("oe");
                    continue block9;
                }
                default: {
                    if (Character.isDigit(c.charValue()) || c.charValue() == '.') {
                        sb.append(c);
                        continue block9;
                    }
                    if (!Character.isLetter(c.charValue())) continue block9;
                    if (!onlyUpper && Character.isUpperCase(c.charValue()) && sb.length() != 0) {
                        sb.append('.');
                    }
                    sb.append(Character.toLowerCase(c.charValue()));
                }
            }
        }
        return sb.toString();
    }

    private static boolean hasOnlyUpperCaseLetters(@NotNull String aStr) {
        char[] cArray = aStr.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (!Character.isLetter(c.charValue()) || !Character.isLowerCase(c.charValue())) continue;
            return false;
        }
        return true;
    }
}

