/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.bytecarousel;

import de.sillysky.nyssr.util.bytecarousel.CByteCarousel;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public final class CByteCarouselOutputStream
extends OutputStream {
    private final CByteCarousel mParent;
    private boolean mClosed = false;

    CByteCarouselOutputStream(CByteCarousel aByteCarousel) {
        this.mParent = aByteCarousel;
    }

    private void checkClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Stream already closed.");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.flush();
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    boolean isClosed() {
        return this.mClosed;
    }

    void reuse() {
        this.mClosed = false;
    }

    @Override
    public void write(byte @NotNull [] aBuf) throws IOException {
        this.checkClosed();
        this.mParent.write(aBuf, 0, aBuf.length);
    }

    @Override
    public void write(byte @NotNull [] aBuf, int aStartPos, int aBytesToWrite) throws IOException {
        this.checkClosed();
        this.mParent.write(aBuf, aStartPos, aBytesToWrite);
    }

    @Override
    public void write(int aByte) throws IOException {
        this.checkClosed();
        this.mParent.write(aByte);
    }
}

