/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilLong {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilLong.class);
    private static final long MAX_INT = 0xFFFFFFFFL;

    private CUtilLong() {
    }

    public static long fromObject(@Nullable Object aValue, long aDefault) {
        long result = aDefault;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = (long)((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (long)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = ((Short)aValue).shortValue();
            } else if (aValue instanceof Integer) {
                result = ((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = (Long)aValue;
            } else if (aValue instanceof Byte) {
                result = ((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = ((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilLong.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to long. Take default value '0L'", aValue);
            }
        }
        return result;
    }

    public static long fromString(@Nullable String aValue) {
        return CUtilLong.fromString(aValue, 0L);
    }

    public static long fromString(@Nullable String aValue, long aDefault) {
        long result = aDefault;
        if (aValue != null) {
            try {
                result = Long.parseLong(aValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static long readUnsignedInt(@NotNull DataInput aStream) throws IOException {
        return (long)aStream.readInt() & 0xFFFFFFFFL;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static String toString(long aValue) {
        return Long.toString(aValue);
    }

    @NotNull
    public static String toString(long aValue, int aMaxLen) {
        String result = CUtilLong.toString(aValue);
        result = CUtilString.shortenString(result, aMaxLen);
        return result;
    }

    @NotNull
    public static String toStringRecord(short aType, long aValue) {
        String key = Short.toString(aType);
        String value = CUtilLong.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static void writeUnsignedInt(@NotNull DataOutput aStream, long aUnsignedInt) throws IOException {
        aStream.writeInt((int)aUnsignedInt);
    }
}

