/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilFloat;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilFloatArray {
    public static final float[] EMPTY = new float[0];
    private static final float DEFAULT_FLOAT = 0.0f;

    private CUtilFloatArray() {
    }

    public static float @Nullable [] copy(float @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    @NotNull
    public static List<Float> fromObject(@Nullable Object element) {
        ArrayList<Float> list;
        block3: {
            float[] ff;
            block5: {
                float[] ff2;
                block4: {
                    block2: {
                        list = new ArrayList<Float>();
                        if (!(element instanceof Float)) break block2;
                        Float f = (Float)element;
                        list.add(f);
                        break block3;
                    }
                    if (!(element instanceof Float[])) break block4;
                    Float[] ff3 = (Float[])element;
                    Collections.addAll(list, ff3);
                    break block3;
                }
                if (!(element instanceof float[])) break block5;
                for (float f : ff2 = (float[])element) {
                    list.add(Float.valueOf(f));
                }
                break block3;
            }
            if (!(element instanceof String)) break block3;
            String s = (String)element;
            for (float f : ff = CUtilFloatArray.fromString(s)) {
                list.add(Float.valueOf(f));
            }
        }
        return list;
    }

    public static float @NotNull [] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (Object element : aValue) {
            if (element == null) continue;
            List<Float> list2 = CUtilFloatArray.fromObject(element);
            list.addAll(list2);
        }
        return CUtilFloatArray.toArray(list);
    }

    public static float @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        float[] value = new float[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = aStream.readFloat();
        }
        return value;
    }

    public static float @NotNull [] random(int aLength) {
        float[] array = new float[aLength];
        for (int i = 0; i < aLength; ++i) {
            array[i] = CUtilRandom.getRandom().nextFloat();
        }
        return array;
    }

    public static float @NotNull [] fromString(@Nullable String aValue) {
        return CUtilFloatArray.fromString(aValue, ",");
    }

    public static float @NotNull [] fromString(@Nullable String aValue, @NotNull String aDelimiter) {
        float[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = new float[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new float[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilFloat.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(float[] aValue1, float[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(float @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : CUtilFloat.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, float @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (float element : aValue) {
                aStream.writeFloat(element);
            }
        }
    }

    public static float @NotNull [] toArray(@Nullable List<Float> aList) {
        if (aList == null || aList.isEmpty()) {
            return EMPTY;
        }
        float[] arr = new float[aList.size()];
        int pos = 0;
        for (Float element : aList) {
            arr[pos] = element == null ? 0.0f : element.floatValue();
            ++pos;
        }
        return arr;
    }
}

