/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log.catcher.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordServiceSetLogLevel
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("184d8372-6a1b-47f9-83eb-386896f3d8ad");
    public static final String NAME = "ServiceSetLogLevel";
    public static final String DESCRIPTION = "Set the log level for one or more loggers.";
    public static final String SLOT_LEVEL = "2";
    public static final String SLOT_LOGGER_NAME = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getLevel(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LEVEL);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getLoggerName(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOGGER_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setLevel(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_LEVEL, slot);
    }

    public static void setLoggerName(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_LOGGER_NAME, slot);
    }
}

