/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log;

import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.IMessageArranger;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CStartTimeMessageArranger
implements IMessageArranger {
    private static final int MAX_LEN = 120;

    void addLinebreaks(@NotNull List<String> aList, @NotNull String aText, int aMaxLength) {
        StringBuilder output = new StringBuilder(aMaxLength + 20);
        String text = aText;
        if (text.length() > aMaxLength) {
            while (output.length() + text.length() > aMaxLength) {
                int firstPartLength = aMaxLength - output.length();
                String firstPart = text.substring(0, firstPartLength);
                output.append(firstPart);
                aList.add(output.toString());
                text = text.substring(firstPartLength);
                output.setLength(0);
                output.append("    ");
            }
            if (!(text = text.trim()).isEmpty()) {
                output.append(text);
            }
            if (output.length() > 0) {
                aList.add(output.toString());
            }
        } else {
            aList.add(output.toString());
        }
    }

    @Override
    @NotNull
    public Collection<String> arrange(@NotNull CLogDto aDto) {
        LocalDateTime timeStamp = aDto.getTimeStamp();
        long differenceInMillis = ChronoUnit.MILLIS.between(CLoggerFactory.getStartTime(), timeStamp);
        String timestampString = String.format("%08d", differenceInMillis);
        String ft = aDto.getFormattedText();
        ArrayList<String> list = new ArrayList<String>();
        this.split(list, ft, 120);
        String firstLine = String.format("%-120s %6s %s %-5s [%s] %s.%s (%s)", new Object[]{list.get(0), aDto.getIndex(), timestampString, aDto.getLevel(), aDto.getThreadName(), aDto.getClassWhereLogged(), aDto.getMethodWhereLogged(), aDto.getLineWhereLogged()});
        list.set(0, firstLine);
        return list;
    }

    private void split(@NotNull List<String> aList, @NotNull String aText, int aMaxLength) {
        String[] lines;
        for (String s : lines = aText.split("\\r?\\n")) {
            if (s.length() > aMaxLength) {
                this.addLinebreaks(aList, s, aMaxLength);
                continue;
            }
            aList.add(s);
        }
    }
}

