/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice.monitor.target.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordTargetMonitorRemoveFilter
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("8080070b-d3a5-47a9-b5b6-8d69def09c6d");
    public static final String NAME = "TargetMonitorRemoveFilter";
    public static final String DESCRIPTION = "Remove one or more or all Target Monitor Filter.";
    public static final String SLOT_FILTER = "2";
    public static final String SLOT_FILTERS = "3";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_OBSERVER = "1";
    public static final String SLOT_REMOVE_ALL = "4";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getFilter(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static CTargetAddress[] getFilters(@NotNull CRecord aRecord, CTargetAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILTERS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress[])slot.getValue();
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress getObserver(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static boolean getRemoveAll(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOVE_ALL);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setFilter(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_FILTER, slot);
    }

    public static void setFilters(@NotNull CRecord aRecord, CTargetAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS_ARRAY, aValue);
        aRecord.addSlot(SLOT_FILTERS, slot);
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setObserver(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_OBSERVER, slot);
    }

    public static void setRemoveAll(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_REMOVE_ALL, slot);
    }
}

