/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice.monitor;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.nanoservice.monitor.CNanoServiceFilter;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.nanoservice.INanoServiceMonitor;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceNotifyObserverAdded;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceNotifyObserverRemoved;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceNotifyServiceDeregistered;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceNotifyServiceRegistered;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.util.CUtilString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNanoServiceMonitor
implements INanoServiceMonitor {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNanoServiceMonitor.class);
    private final UUID REQUESTER_ID = UUID.randomUUID();
    private final Map<CTargetAddress, Set<CNanoServiceFilter>> mFilter = new HashMap<CTargetAddress, Set<CNanoServiceFilter>>(10);
    private final IId mNID;
    private final IMessageSender mMessageSender;
    private final IListenerRegistry mAddressRegistry;

    public CNanoServiceMonitor(@NotNull IId aNID, @NotNull IMessageSender aMessageSender, @NotNull IListenerRegistry aAddressRegistry) {
        this.mNID = aNID;
        this.mMessageSender = aMessageSender;
        this.mAddressRegistry = aAddressRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(@NotNull CTargetAddress aObserver, @NotNull IId aSID) {
        CNanoServiceFilter filter = new CNanoServiceFilter(aSID);
        LOG.debug("Add filter {} for {} in namespace {}.", aSID, filter, this.mNID);
        boolean exist = this.mAddressRegistry.hasAddress(this.REQUESTER_ID, aObserver);
        if (!exist) {
            this.mAddressRegistry.addAddress(this.REQUESTER_ID, aObserver);
        }
        Map<CTargetAddress, Set<CNanoServiceFilter>> map = this.mFilter;
        synchronized (map) {
            Set set = this.mFilter.computeIfAbsent(aObserver, k -> new HashSet());
            set.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean match(@NotNull IId aSID, @NotNull CTargetAddress aAddress) {
        boolean send = false;
        Map<CTargetAddress, Set<CNanoServiceFilter>> map = this.mFilter;
        synchronized (map) {
            Set<CNanoServiceFilter> filter = this.mFilter.get(aAddress);
            for (CNanoServiceFilter f : filter) {
                if (!f.match(aSID)) continue;
                send = true;
                break;
            }
        }
        return send;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAddress(@NotNull CTargetAddress aObserver) {
        this.mAddressRegistry.removeAddress(this.REQUESTER_ID, aObserver);
        Map<CTargetAddress, Set<CNanoServiceFilter>> map = this.mFilter;
        synchronized (map) {
            this.mFilter.remove(aObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(@NotNull CTargetAddress aAddress, @NotNull IId aSID) {
        LOG.debug("Remove Filter {} for Target {} in Namespace {}", aSID, aAddress, this.mNID);
        Map<CTargetAddress, Set<CNanoServiceFilter>> map = this.mFilter;
        synchronized (map) {
            Set<CNanoServiceFilter> filters = this.mFilter.get(aAddress);
            if (filters != null) {
                filters.removeIf(filter -> filter.match(aSID));
            }
        }
    }

    private void send(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mMessageSender.sendNotification(aEnvelope, aRecord);
    }

    public void triggerObserverAdded(@NotNull IId aSID, @Nullable String aName, @NotNull CTargetAddress aObserver) {
        CTargetAddress[] addresses;
        for (CTargetAddress address : addresses = this.mAddressRegistry.getAddresses(this.REQUESTER_ID)) {
            boolean send = this.match(aSID, address);
            if (!send) continue;
            try {
                CEnvelope env = CEnvelope.forSingleTarget(address);
                env.setWantAnswer(false);
                CRecord rec = CRecordNanoServiceNotifyObserverAdded.create();
                CRecordNanoServiceNotifyObserverAdded.setSid(rec, aSID);
                CRecordNanoServiceNotifyObserverAdded.setNid(rec, this.mNID);
                if (CUtilString.isValid(aName)) {
                    CRecordNanoServiceNotifyObserverAdded.setName(rec, aName);
                }
                CRecordNanoServiceNotifyObserverAdded.setObserver(rec, aObserver);
                this.send(env, rec);
            }
            catch (CException e) {
                LOG.error("Can't send notification to {} (Observer {} added to {} in namespace {})", address, aObserver, aSID, this.mNID);
            }
        }
    }

    public void triggerObserverRemoved(@NotNull IId aSID, @Nullable String aName, @NotNull CTargetAddress aObserver) {
        CTargetAddress[] addresses;
        for (CTargetAddress address : addresses = this.mAddressRegistry.getAddresses(this.REQUESTER_ID)) {
            boolean send = this.match(aSID, address);
            if (!send) continue;
            try {
                CEnvelope env = CEnvelope.forSingleTarget(address);
                env.setWantAnswer(false);
                CRecord rec = CRecordNanoServiceNotifyObserverRemoved.create();
                CRecordNanoServiceNotifyObserverRemoved.setSid(rec, aSID);
                CRecordNanoServiceNotifyObserverRemoved.setNid(rec, this.mNID);
                if (CUtilString.isValid(aName)) {
                    CRecordNanoServiceNotifyObserverRemoved.setName(rec, aName);
                }
                CRecordNanoServiceNotifyObserverRemoved.setObserver(rec, aObserver);
                this.send(env, rec);
            }
            catch (CException e) {
                LOG.error("Can't send notification to {} (Observer {} removed from {} in namespace {})", address, aObserver, aSID, this.mNID);
            }
        }
    }

    public void triggerServiceDeregistered(@NotNull IId aSID, @Nullable String aName) {
        CTargetAddress[] addresses;
        for (CTargetAddress address : addresses = this.mAddressRegistry.getAddresses(this.REQUESTER_ID)) {
            boolean send = this.match(aSID, address);
            if (!send) continue;
            try {
                CEnvelope env = CEnvelope.forSingleTarget(address);
                env.setWantAnswer(false);
                CRecord rec = CRecordNanoServiceNotifyServiceDeregistered.create();
                CRecordNanoServiceNotifyServiceDeregistered.setSid(rec, aSID);
                CRecordNanoServiceNotifyServiceDeregistered.setNid(rec, this.mNID);
                if (CUtilString.isValid(aName)) {
                    CRecordNanoServiceNotifyServiceDeregistered.setName(rec, aName);
                }
                this.send(env, rec);
            }
            catch (CException e) {
                LOG.error("Can't send notification to {} (SID {} deregistered in namespace {})", address, aSID, this.mNID);
            }
        }
    }

    public void triggerServiceRegistered(@NotNull IId aSID, @Nullable String aName) {
        CTargetAddress[] addresses;
        for (CTargetAddress address : addresses = this.mAddressRegistry.getAddresses(this.REQUESTER_ID)) {
            boolean send = this.match(aSID, address);
            if (!send) continue;
            try {
                CEnvelope env = CEnvelope.forSingleTarget(address);
                env.setWantAnswer(false);
                CRecord rec = CRecordNanoServiceNotifyServiceRegistered.create();
                CRecordNanoServiceNotifyServiceRegistered.setSid(rec, aSID);
                CRecordNanoServiceNotifyServiceRegistered.setNid(rec, this.mNID);
                if (CUtilString.isValid(aName)) {
                    CRecordNanoServiceNotifyServiceRegistered.setName(rec, aName);
                }
                this.send(env, rec);
            }
            catch (CException e) {
                LOG.error("Can't send notification to {} (SID {} registered in namespace {})", address, aSID, this.mNID);
            }
        }
    }
}

