/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.nanoservice.CNanoServiceRegistry;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.hook.IMessageHookRegistry;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistryFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import org.jetbrains.annotations.NotNull;

final class CNanoServiceRegistryFactory
implements INanoServiceRegistryFactory,
IService {
    private INameDb mNameDb;
    private IListenerRegistry mListenerRegistry;
    private IMessageHookRegistry mMessageHookRegistry;
    private IMessageSender mMessageSender;

    CNanoServiceRegistryFactory() {
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IListenerRegistry.class);
        aDependencyList.add(IMessageHookRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mNameDb = aServiceRegistry.getService(INameDb.class);
        this.mListenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        this.mMessageHookRegistry = aServiceRegistry.getService(IMessageHookRegistry.class);
        aServiceRegistry.registerService(INanoServiceRegistryFactory.class, this);
    }

    @Override
    @NotNull
    public INanoServiceRegistry createRegistry(@NotNull IId aNID) {
        return new CNanoServiceRegistry(aNID, this.mMessageSender, this.mListenerRegistry, this.mMessageHookRegistry, this.mNameDb);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void deleteRegistry(@NotNull INanoServiceRegistry aNanoServiceRegistry) {
        aNanoServiceRegistry.deactivate();
    }
}

