/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log.catcher.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.catcher.ILogCatcher;
import de.sillysky.nyssr.log.catcher.records.CRecordNotifyLogCaught;
import de.sillysky.nyssr.log.catcher.records.CRecordServiceAddLogObserver;
import de.sillysky.nyssr.log.catcher.records.CRecordServiceLogCatcherAvailable;
import de.sillysky.nyssr.log.catcher.records.CRecordServiceRemoveLogObserver;
import de.sillysky.nyssr.log.catcher.records.CRecordServiceSetLogLevel;
import de.sillysky.nyssr.log.catcher.records.CRecordUpdateLogVars;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class CTargetLogCatcher
extends CTarget
implements IService {
    private static final String FILTER = "nid=MONITOR";
    private static final String[] LEVELS = new String[]{ELevel.TRACE.toString(), ELevel.DEBUG.toString(), ELevel.INFO.toString(), ELevel.WARN.toString(), ELevel.ERROR.toString(), ELevel.OFF.toString()};
    private ILogCatcher mLogCatcher;

    CTargetLogCatcher() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordServiceAddLogObserver.ID, this::asyncAddLogObserver);
        this.addMessageHandler(CRecordNotifyLogCaught.ID, this::asyncNotifyLogCaught);
        this.addMessageHandler(CRecordServiceRemoveLogObserver.ID, this::asyncRemoveLogObserver);
        this.addMessageHandler(CRecordServiceSetLogLevel.ID, this::asyncSetLogLevel);
    }

    static void addDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(ILogCatcher.class);
        aDependencyList.add(ITargetRegistry.class, FILTER);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mLogCatcher = aServiceRegistry.getService(ILogCatcher.class);
        ITargetRegistry tr = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget(this, CWellKnownTID.LOG_CATCHER);
    }

    private boolean asyncAddLogObserver(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mLogCatcher.addListener(aEnvelope.getSender());
        this.sendLoggerLevels(aEnvelope.getSender());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyLogCaught(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode != 0) {
                this.mLogCatcher.removeListener(aEnvelope.getSender());
            }
            return true;
        }
        return false;
    }

    private boolean asyncRemoveLogObserver(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mLogCatcher.removeListener(aEnvelope.getSender());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSetLogLevel(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String[] names = CRecordServiceSetLogLevel.getLoggerName(aRecord, null);
        if (names == null) {
            aEnvelope.setResult(7, "Names are null.");
            return true;
        }
        String[] levels = CRecordServiceSetLogLevel.getLevel(aRecord, null);
        if (levels == null) {
            aEnvelope.setResult(7, "Levels are null.");
            return true;
        }
        if (levels.length != names.length) {
            aEnvelope.setResult(7, "Names array length must be the same like level array length.");
            return true;
        }
        for (int i = 0; i < names.length; ++i) {
            ELevel level = ELevel.convert(levels[i], ELevel.INFO);
            this.mLogCatcher.setLoggerLevel(names[i], level);
        }
        this.sendLoggerLevels(aEnvelope.getSender());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecordHelper.addObserver(CRecordServiceAddLogObserver.class, this, false);
        CRecordHelper.addObserver(CRecordServiceRemoveLogObserver.class, this, false);
        CRecordHelper.addObserver(CRecordServiceSetLogLevel.class, this, false);
        this.mLogCatcher.start();
        this.sendLogCatcherAvailable(true);
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private void sendLogCatcherAvailable(boolean aAvailable) throws CException {
        CEnvelope env = new CEnvelope();
        CRecord rec = CRecordServiceLogCatcherAvailable.create();
        CRecordServiceLogCatcherAvailable.setAvailable(rec, aAvailable);
        this.sendNotification(env, rec);
    }

    private void sendLoggerLevels(CTargetAddress aAddress) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget(aAddress);
        env.setPriority(EPriority.LOW);
        CRecord rec = CRecordUpdateLogVars.create();
        Map<String, ELevel> loggerLevels = this.mLogCatcher.getLoggerLevels();
        int size = loggerLevels.size() + 1;
        if (size > 0) {
            String[] arrLoggerNames = new String[size];
            String[] arrLevelNames = new String[size];
            arrLoggerNames[0] = "";
            arrLevelNames[0] = this.mLogCatcher.getRootLevel().toString();
            int i = 1;
            for (Map.Entry<String, ELevel> entry : loggerLevels.entrySet()) {
                arrLoggerNames[i] = entry.getKey();
                arrLevelNames[i] = entry.getValue().toString();
                ++i;
            }
            CRecordUpdateLogVars.setLoggerLevel(rec, arrLevelNames);
            CRecordUpdateLogVars.setLoggerNames(rec, arrLoggerNames);
        }
        CRecordUpdateLogVars.setKnownLevels(rec, LEVELS);
        CRecordUpdateLogVars.setPattern(rec, "");
        this.sendNotification(env, rec);
    }
}

