/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingNode;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTreeNode;
import de.sillysky.nyssr.remoteskin.model.enums.ERelation;
import de.sillysky.nyssr.util.CUtilString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTreeOfNodes {
    private final Map<String, CTreeNode> mNodes = new HashMap<String, CTreeNode>();
    private final JTree mTree;
    private CTreeNode mRootNode;

    CTreeOfNodes(@NotNull JTree aTree) {
        this.mTree = aTree;
        this.clear();
    }

    void clear() {
        this.mNodes.clear();
        CTreeNode rn = new CTreeNode("root", "root", null);
        this.setRootNode(rn);
    }

    @Nullable
    CTreeNode getRootNode() {
        return this.mRootNode;
    }

    void setRootNode(@NotNull CTreeNode aRootNode) {
        this.mRootNode = aRootNode;
        this.mNodes.put(this.mRootNode.getId(), this.mRootNode);
        this.mTree.setModel(new DefaultTreeModel(this.mRootNode.getSwingNode()));
    }

    void add(@NotNull CTreeNode aNode, @Nullable String aParentId) {
        this.add(aNode, aParentId, -1);
    }

    void add(@NotNull CTreeNode aNode, @Nullable String aParentId, int aIndex) {
        if (CUtilString.isEmpty((String)aParentId)) {
            this.mNodes.clear();
        }
        this.addRecursivelyToMap(aNode);
        CTreeNode parent = aParentId == null ? null : this.mNodes.get(aParentId);
        if (parent != null) {
            if (aIndex >= 0) {
                parent.children().add(aIndex, aNode);
            } else {
                parent.addChild(aNode);
            }
            aNode.setParent(parent);
            CSwingNode swingNode = parent.getSwingNode();
            swingNode.add(aNode.getSwingNode());
        } else {
            this.mRootNode = aNode;
            aNode.setParent(null);
        }
    }

    private void addRecursivelyToMap(@NotNull CTreeNode aNode) {
        this.mNodes.put(aNode.getId(), aNode);
        for (CTreeNode child : aNode.children()) {
            this.addRecursivelyToMap(child);
        }
    }

    void remove(String aId) {
        CTreeNode node = this.mNodes.get(aId);
        if (node != null) {
            this.removeRecursively(aId);
            CTreeNode parent = node.getParent();
            if (parent == null) {
                if (this.mRootNode.equals(node)) {
                    this.mRootNode = null;
                }
            } else {
                parent.removeChild(node);
                node.setParent(null);
            }
        }
    }

    private void removeRecursively(@NotNull String aNodeId) {
        CTreeNode node = this.mNodes.remove(aNodeId);
        if (node != null) {
            for (CTreeNode child : node.children()) {
                this.removeRecursively(child.getId());
            }
        }
    }

    @Nullable
    CTreeNode get(@Nullable String aId) {
        if (aId != null) {
            return this.mNodes.get(aId);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{count=" + this.mNodes.size() + "}";
    }

    public void setNodes(@NotNull CTreeNode aNode) {
        this.mNodes.clear();
        this.add(aNode, null);
    }

    void insert(@NotNull CTreeNode aNode, @NotNull ERelation aRelation, @NotNull String aRelationNodeId) {
        CTreeNode relationNode = this.mNodes.get(aRelationNodeId);
        if (relationNode != null) {
            switch (aRelation) {
                case child: {
                    this.add(aNode, aRelationNodeId);
                    break;
                }
                case after: {
                    int i;
                    CTreeNode parent = relationNode.getParent();
                    if (parent == null || (i = parent.children().indexOf(relationNode)) < 0) break;
                    this.add(aNode, parent.getId(), i + 1);
                    break;
                }
                case before: {
                    int i;
                    CTreeNode parent = relationNode.getParent();
                    if (parent == null || (i = parent.children().indexOf(relationNode)) < 0) break;
                    this.add(aNode, parent.getId(), i);
                    break;
                }
            }
        }
    }

    int size() {
        return this.mNodes.size();
    }

    @Nullable
    CTreeNode getNodeByPath(@NotNull TreePath aPath) {
        Object last = aPath.getLastPathComponent();
        if (last instanceof CSwingNode) {
            CSwingNode swingNode = (CSwingNode)last;
            return swingNode.getNode();
        }
        return null;
    }
}

