/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.events;

import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.enums.EWindowState;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;

public class CWindowEvent {
    private CWindowEvent() {
    }

    public static void sendEvent(@NotNull CWidget aWidget, @NotNull String aKey, @NotNull WindowEvent aWindowEvent) {
        Window oppositeWindow = aWindowEvent.getOppositeWindow();
        CWidget opposite = aWidget.getContext().findComponent((Component)oppositeWindow);
        EWindowState newState = CWindowEvent.convertState(aWindowEvent.getNewState());
        EWindowState oldState = CWindowEvent.convertState(aWindowEvent.getOldState());
        CEventWindowNotification ev = new CEventWindowNotification(opposite == null ? null : opposite.getId(), newState, oldState);
        Object jo = ev.toJson();
        aWidget.addNotification(aKey, jo);
        aWidget.sendNotification();
    }

    private static EWindowState convertState(int aSwingState) {
        if ((aSwingState & 1) == 1) {
            return EWindowState.iconified;
        }
        if ((aSwingState & 6) == 6) {
            return EWindowState.maximized_both;
        }
        if ((aSwingState & 2) == 2) {
            return EWindowState.maximized_horizontal;
        }
        if ((aSwingState & 4) == 4) {
            return EWindowState.maximized_vertical;
        }
        return EWindowState.normal;
    }
}

