/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

public enum EHashType {
    EMPTY(0),
    MD2(1),
    MD5(2),
    SHA1(3),
    SHA256(4),
    SHA384(5),
    SHA512(6);

    private final byte mValue;

    public static EHashType get(byte aValue) {
        EHashType[] arr = EHashType.values();
        if (aValue >= 0 && aValue < arr.length) {
            return arr[aValue];
        }
        return EMPTY;
    }

    public static EHashType getSave(byte aValue) {
        return switch (aValue) {
            case 1 -> MD2;
            case 2 -> MD5;
            case 3 -> SHA1;
            case 4 -> SHA256;
            case 5 -> SHA384;
            case 6 -> SHA512;
            default -> EMPTY;
        };
    }

    private EHashType(byte aValue) {
        this.mValue = aValue;
    }

    public byte getValue() {
        return this.mValue;
    }
}

