/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class CrockfordBase32 {
    protected static final int MASK_8BITS = 255;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MASK_5BITS = 31;
    private static final int BITS_PER_ENCODED_BYTE = 5;
    private static final int BYTES_PER_ENCODED_BLOCK = 8;
    private static final int BYTES_PER_UNENCODED_BLOCK = 5;
    private static final byte PAD = 61;
    private static final byte[] ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 74, 75, 77, 78, 80, 81, 82, 83, 84, 86, 87, 88, 89, 90};
    private final int mDecodeSize;
    private final int mEncodeSize;
    private final boolean mUsePaddingCharacter;
    protected byte[] mBuffer;
    protected int mPos;
    protected boolean mEof;
    protected int mModulus;
    private long mBitWorkArea;

    public CrockfordBase32() {
        this(false);
    }

    public CrockfordBase32(boolean aUsePaddingCharacter) {
        this.mUsePaddingCharacter = aUsePaddingCharacter;
        this.mEncodeSize = 8;
        this.mDecodeSize = this.mEncodeSize - 1;
    }

    private static byte decode(byte aOctet) {
        switch (aOctet) {
            case 48: 
            case 79: 
            case 111: {
                return 0;
            }
            case 49: 
            case 73: 
            case 76: 
            case 105: 
            case 108: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
            case 71: 
            case 103: {
                return 16;
            }
            case 72: 
            case 104: {
                return 17;
            }
            case 74: 
            case 106: {
                return 18;
            }
            case 75: 
            case 107: {
                return 19;
            }
            case 77: 
            case 109: {
                return 20;
            }
            case 78: 
            case 110: {
                return 21;
            }
            case 80: 
            case 112: {
                return 22;
            }
            case 81: 
            case 113: {
                return 23;
            }
            case 82: 
            case 114: {
                return 24;
            }
            case 83: 
            case 115: {
                return 25;
            }
            case 84: 
            case 116: {
                return 26;
            }
            case 85: 
            case 86: 
            case 117: 
            case 118: {
                return 27;
            }
            case 87: 
            case 119: {
                return 28;
            }
            case 88: 
            case 120: {
                return 29;
            }
            case 89: 
            case 121: {
                return 30;
            }
            case 90: 
            case 122: {
                return 31;
            }
        }
        return -1;
    }

    protected static boolean isWhiteSpace(byte aByteToCheck) {
        switch (aByteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInAlphabet(@NotNull String aBase32) {
        return CrockfordBase32.isInAlphabet(aBase32.getBytes(UTF8), true);
    }

    public static boolean isInAlphabet(byte @NotNull [] aArrayOctet, boolean aAllowWSPad) {
        for (byte aB : aArrayOctet) {
            if (CrockfordBase32.isInAlphabet(aB) || aAllowWSPad && (aB == 61 || CrockfordBase32.isWhiteSpace(aB))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInAlphabet(byte aOctet) {
        return CrockfordBase32.decode(aOctet) != -1;
    }

    int available() {
        return this.mBuffer != null ? this.mPos : 0;
    }

    private void resizeBuffer() {
        if (this.mBuffer == null) {
            this.mBuffer = new byte[8192];
            this.mPos = 0;
        } else {
            byte[] b = new byte[this.mBuffer.length * 2];
            System.arraycopy(this.mBuffer, 0, b, 0, this.mBuffer.length);
            this.mBuffer = b;
        }
    }

    protected void ensureBufferSize(int aSize) {
        if (this.mBuffer == null || this.mBuffer.length < this.mPos + aSize) {
            this.resizeBuffer();
        }
    }

    int readResults(byte[] aB) {
        if (this.mBuffer != null) {
            int len = this.available();
            System.arraycopy(this.mBuffer, 0, aB, 0, len);
            this.mBuffer = null;
            return len;
        }
        return this.mEof ? -1 : 0;
    }

    private void reset() {
        this.mBuffer = null;
        this.mPos = 0;
        this.mModulus = 0;
        this.mEof = false;
    }

    public String encodeToString(@NotNull String aArray) {
        return this.encodeToString(aArray.getBytes(UTF8));
    }

    public String encodeToString(byte[] aArray) {
        return new String(this.encode(aArray), UTF8);
    }

    public String decodeToString(@NotNull String aArray) {
        return this.decodeToString(aArray.getBytes(UTF8));
    }

    public String decodeToString(byte[] aArray) {
        return new String(this.decode(aArray), UTF8);
    }

    public byte[] decode(@NotNull String aArray) {
        return this.decode(aArray.getBytes(UTF8));
    }

    public byte[] encode(@NotNull String aArray) {
        return this.encode(aArray.getBytes(UTF8));
    }

    public byte[] decode(byte[] aArray) {
        this.reset();
        if (aArray == null || aArray.length == 0) {
            return aArray;
        }
        this.decode(aArray, 0, aArray.length);
        this.decode(aArray, 0, -1);
        byte[] result = new byte[this.mPos];
        this.readResults(result);
        return result;
    }

    public byte[] encode(byte[] aArray) {
        this.reset();
        if (aArray == null || aArray.length == 0) {
            return aArray;
        }
        this.encode(aArray, 0, aArray.length);
        this.encode(aArray, 0, -1);
        byte[] buf = new byte[this.mPos];
        this.readResults(buf);
        return buf;
    }

    public long getEncodedLength(byte @NotNull [] aArray) {
        return (long)((aArray.length + 5 - 1) / 5) * 8L;
    }

    void decode(byte[] aIn, int aInPos, int aInAvail) {
        if (this.mEof) {
            return;
        }
        int pos = aInPos;
        if (aInAvail < 0) {
            this.mEof = true;
        }
        for (int i = 0; i < aInAvail; ++i) {
            byte b;
            if ((b = aIn[pos++]) == 61) {
                this.mEof = true;
                break;
            }
            this.ensureBufferSize(this.mDecodeSize);
            if (!CrockfordBase32.isInAlphabet(b)) continue;
            byte result = CrockfordBase32.decode(b);
            this.mModulus = (this.mModulus + 1) % 8;
            this.mBitWorkArea = (this.mBitWorkArea << 5) + (long)result;
            if (this.mModulus != 0) continue;
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 32 & 0xFFL);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 24 & 0xFFL);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 16 & 0xFFL);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFFL);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFFL);
        }
        if (this.mEof && this.mModulus >= 2) {
            this.ensureBufferSize(this.mDecodeSize);
            switch (this.mModulus) {
                case 2: {
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 2 & 0xFFL);
                    break;
                }
                case 3: {
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 7 & 0xFFL);
                    break;
                }
                case 4: {
                    this.mBitWorkArea >>= 4;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFFL);
                    break;
                }
                case 5: {
                    this.mBitWorkArea >>= 1;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 16 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFFL);
                    break;
                }
                case 6: {
                    this.mBitWorkArea >>= 6;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 16 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFFL);
                    break;
                }
                case 7: {
                    this.mBitWorkArea >>= 3;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 24 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 16 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFFL);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFFL);
                }
            }
        }
    }

    void encode(byte[] aIn, int aInPos, int aInAvail) {
        if (this.mEof) {
            return;
        }
        int inPos = aInPos;
        if (aInAvail < 0) {
            this.mEof = true;
            if (0 == this.mModulus) {
                return;
            }
            this.ensureBufferSize(this.mEncodeSize);
            int savedPos = this.mPos;
            switch (this.mModulus) {
                case 1: {
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 3) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea << 2) & 0x1F];
                    if (!this.mUsePaddingCharacter) break;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    break;
                }
                case 2: {
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 11) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 6) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 1) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea << 4) & 0x1F];
                    if (!this.mUsePaddingCharacter) break;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    break;
                }
                case 3: {
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 19) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 14) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 9) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 4) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea << 1) & 0x1F];
                    if (!this.mUsePaddingCharacter) break;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    break;
                }
                case 4: {
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 27) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 22) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 17) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 12) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 7) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 2) & 0x1F];
                    this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea << 3) & 0x1F];
                    if (!this.mUsePaddingCharacter) break;
                    this.mBuffer[this.mPos++] = 61;
                }
            }
        } else {
            for (int i = 0; i < aInAvail; ++i) {
                this.ensureBufferSize(this.mEncodeSize);
                this.mModulus = (this.mModulus + 1) % 5;
                int b = aIn[inPos++];
                if (b < 0) {
                    b += 256;
                }
                this.mBitWorkArea = (this.mBitWorkArea << 8) + (long)b;
                if (0 != this.mModulus) continue;
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 35) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 30) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 25) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 20) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 15) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 10) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)(this.mBitWorkArea >> 5) & 0x1F];
                this.mBuffer[this.mPos++] = ENCODE_TABLE[(int)this.mBitWorkArea & 0x1F];
            }
        }
    }
}

