/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilByte;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilByteArray {
    public static final byte[] EMPTY = new byte[0];
    private static final int ITEM_STRING_LENGTH = 3;
    private static final int MAX_BYTE = 255;
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilByteArray.class);

    private CUtilByteArray() {
    }

    public static byte @Nullable [] fromObject(@Nullable Object aValue) {
        if (aValue instanceof Byte) {
            Byte b = (Byte)aValue;
            return new byte[]{b};
        }
        if (aValue instanceof byte[]) {
            return (byte[])aValue;
        }
        if (aValue instanceof Byte[]) {
            Byte[] bbb = (Byte[])aValue;
            byte[] bb = new byte[bbb.length];
            for (int i = 0; i < bbb.length; ++i) {
                bb[i] = bbb[i];
            }
            return bb;
        }
        if (aValue instanceof String) {
            return CUtilByteArray.fromString((String)aValue);
        }
        return null;
    }

    public static byte @Nullable [] copy(byte @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static byte @NotNull [] createFilled(int aLength, byte aByte) {
        byte[] array = new byte[aLength];
        Arrays.fill(array, aByte);
        return array;
    }

    public static byte[] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Object element : aValue) {
            byte[] bb = CUtilByteArray.fromObject(element);
            if (bb == null || bb.length <= 0) continue;
            list.add(bb);
        }
        int count = 0;
        for (byte[] element : list) {
            count += element.length;
        }
        byte[] arr = new byte[count];
        int pos = 0;
        for (byte[] element : list) {
            System.arraycopy(element, 0, arr, pos, element.length);
            pos += element.length;
        }
        return arr;
    }

    public static byte @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            return EMPTY;
        }
        byte[] value = new byte[len - 1];
        aStream.readFully(value);
        return value;
    }

    public static byte @NotNull [] random(int aLength) {
        byte[] array = new byte[aLength];
        CUtilRandom.getRandom().nextBytes(array);
        return array;
    }

    public static byte[] fromString(@Nullable String aValue) {
        return CUtilByteArray.fromString(aValue, ",");
    }

    public static byte[] fromString(@Nullable String aValue, @Nullable String aDelimiter) {
        byte[] arr;
        if ("null".equals(aValue)) {
            arr = null;
        } else if (aValue == null || aValue.isEmpty()) {
            arr = EMPTY;
        } else {
            String[] tokens;
            if (aDelimiter != null) {
                tokens = aValue.split(aDelimiter, -1);
            } else {
                int len = aValue.length() / 2;
                tokens = new String[len];
                for (int i = 0; i < len; ++i) {
                    tokens[i] = aValue.substring(i * 2, i * 2 + 2);
                }
            }
            arr = new byte[tokens.length];
            int i = 0;
            for (String token : tokens) {
                arr[i++] = CUtilByte.fromObject(token, (byte)0);
            }
        }
        return arr;
    }

    public static boolean isEmpty(byte[] aArr) {
        return aArr == null || aArr.length == 0;
    }

    public static boolean isEqual(byte[] aValue1, byte[] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(byte @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : CUtilByte.toString(aValue[index]));
    }

    @NotNull
    public static String toString1(byte @NotNull [] aValue) {
        StringBuilder sb = new StringBuilder(aValue.length * 2);
        for (byte b : aValue) {
            int r1 = (b & 0xFF) + 256;
            String s1 = Integer.toString(r1, 16);
            String s2 = s1.substring(1);
            sb.append(s2);
        }
        return sb.toString();
    }

    @NotNull
    public static String toString2(byte @NotNull [] aValue) {
        StringBuilder sb = new StringBuilder(aValue.length * 2);
        for (byte b : aValue) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    @NotNull
    public static String toString3(byte @NotNull [] aValue) {
        StringBuilder sb = new StringBuilder(aValue.length * 2);
        for (byte b : aValue) {
            CUtilByte.append(sb, b);
        }
        return sb.toString();
    }

    public static void toStream(@NotNull DataOutput aStream, byte[] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            if (aValue.length > 0) {
                aStream.write(aValue);
            }
        }
    }

    public static boolean equals(byte[] aBytes1, int aPos1, byte[] aBytes2, int aPos2, int aLength) throws CException {
        if (aPos1 < 0 || aPos2 < 0) {
            throw new CException(15).append("Position out of Range");
        }
        if (aPos1 + aLength > aBytes1.length || aPos2 + aLength > aBytes2.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (aBytes1[aPos1 + i] == aBytes2[aPos2 + i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static byte @NotNull [] fromCharArray(char @NotNull [] a) {
        int len = 0;
        for (char c : a) {
            if (c > '\u07ff') {
                len += 3;
                continue;
            }
            if (c > '\u007f') {
                len += 2;
                continue;
            }
            ++len;
        }
        byte[] result = new byte[len];
        int i = 0;
        for (char c : a) {
            if (c > '\u07ff') {
                result[i++] = (byte)(c >> 12 & 0xF | 0xE0);
                result[i++] = (byte)(c >> 6 & 0x3F | 0x80);
                result[i++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            if (c > '\u007f') {
                result[i++] = (byte)(c >> 6 & 0x1F | 0xC0);
                result[i++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            result[i++] = (byte)(c & 0x7F);
        }
        return result;
    }

    public static byte @NotNull [] append(byte @NotNull [] aArray1, byte @NotNull [] aArray2) {
        byte[] combined = new byte[aArray1.length + aArray2.length];
        System.arraycopy(aArray1, 0, combined, 0, aArray1.length);
        System.arraycopy(aArray2, 0, combined, aArray1.length, aArray2.length);
        return combined;
    }

    public static int hashcode(byte[] aByteArray) {
        return Arrays.hashCode(aByteArray);
    }
}

