/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.message;

import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMessage {
    private static final int SB1 = 10;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;

    public CMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
    }

    public CMessage(@NotNull CMessage aTemplate) {
        this.mEnvelope = CEnvelope.copy(aTemplate.mEnvelope);
        this.mRecord = new CRecord(aTemplate.getRecord());
    }

    @NotNull
    public static CMessage fromStream(@NotNull DataInput aStream) throws IOException {
        CEnvelope env = CEnvelope.fromStream(aStream);
        CRecord rec = CRecord.fromStream(aStream);
        return new CMessage(env, rec);
    }

    @NotNull
    public CEnvelope getEnvelope() {
        return this.mEnvelope;
    }

    @NotNull
    public CRecord getRecord() {
        return this.mRecord;
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        this.mEnvelope.toStream(aStream);
        this.mRecord.toStream(aStream);
    }

    @NotNull
    public String toString() {
        String s1 = this.mEnvelope.toString();
        String s2 = this.mRecord.toString();
        StringBuilder sb = new StringBuilder(s1.length() + s2.length() + 10 + 2 * CUtilString.LINE_CRLF.length());
        sb.append(CUtilString.CRLF);
        sb.append(CUtilString.LINE_CRLF);
        sb.append(s1);
        sb.append(CUtilString.CRLF);
        sb.append(s2);
        sb.append(CUtilString.CRLF);
        sb.append(CUtilString.LINE_CRLF);
        return sb.toString();
    }

    public boolean equals(@Nullable Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CMessage message = (CMessage)aO;
        boolean envEq = this.mEnvelope.equals(message.mEnvelope);
        boolean recEq = this.mRecord.equals(message.mRecord);
        return envEq && recEq;
    }

    public int hashCode() {
        return Objects.hash(this.mEnvelope, this.mRecord);
    }
}

