/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.CJobStartStarter;
import de.sillysky.nyssr.impl.service.CServiceDependency;
import de.sillysky.nyssr.impl.service.CServiceDependencyList;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.service.CServiceStarter;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

class CJobAddStarter
implements Runnable {
    private final CServiceRegistry mServiceRegistry;
    private final IServiceStarter mStarter;

    CJobAddStarter(@NotNull CServiceRegistry aServiceRegistry, @NotNull IServiceStarter aStarter) {
        this.mServiceRegistry = aServiceRegistry;
        this.mStarter = aStarter;
    }

    @Override
    public void run() {
        CServiceRegistry.LOG.debug("++ {} (Starter)", this.mStarter.getClass().getSimpleName());
        this.mServiceRegistry.setDirty(true);
        CServiceDependencyList deps = new CServiceDependencyList();
        this.mStarter.getDependencies(deps);
        CServiceStarter starter = new CServiceStarter(this.mStarter, deps);
        String name = starter.getName();
        for (CServiceDependency dep : deps) {
            if (!this.mServiceRegistry.isNotRegistered(dep)) continue;
            this.mServiceRegistry.privateAddWaitingStarter(name, starter);
            return;
        }
        CJobStartStarter job = new CJobStartStarter(this.mServiceRegistry, starter);
        this.mServiceRegistry.getThreadPoolManager().submitJob(job);
    }
}

