/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.queue;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.queue.CMessageQueueRegistry;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IPostMan;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistryFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import org.jetbrains.annotations.NotNull;

final class CMessageQueueRegistryFactory
implements IMessageQueueRegistryFactory,
IService {
    private IMessageSender mMessageSender;
    private IListenerRegistry mListenerRegistry;

    CMessageQueueRegistryFactory() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IListenerRegistry.class);
        aDependencyList.add(IMessageSender.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mListenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        aServiceRegistry.registerService(IMessageQueueRegistryFactory.class, this);
    }

    @Override
    public IMessageQueueRegistry createRegistry(IId aNID, IPostMan aPostMan) throws CException {
        if (aNID == null) {
            throw new CException(7).append("Namespace ").append(": Cannot create queue registry without Namespace ID.");
        }
        if (aPostMan == null) {
            throw new CException(7).append("Namespace ").append(aNID).append(": Cannot create queue registry without PostMan.");
        }
        return new CMessageQueueRegistry(aNID, aPostMan, this.mMessageSender, this.mListenerRegistry);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    public void freeRegistry(IMessageQueueRegistry aRegistry) {
        if (aRegistry != null) {
            aRegistry.deactivate();
        }
    }
}

