/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.tree;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.tree.CTreeModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventEnsureVisible;
import de.sillysky.nyssr.remoteskin.model.events.CEventExpansionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventIdAndValue;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeSelectionNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IExpansionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITreeChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITreeSelectionListener;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CTreeUi {
    private static final String SEARCH_9_1 = "id1-1";
    private static final String SEARCH_9_2 = "id14-1";
    private final CTreeModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs304;
    private final CWidgetSetId mWs30410;
    private final CWidgetSetId mWs30411;
    private CWidgetId m304PanelMain;
    private CWidgetId m8;
    private CWidgetId m8helper;
    private boolean m8Expanded = true;
    private CWidgetId m9;
    private CWidgetId m9helper;
    private String m9searchString = "id1-1";
    private CWidgetId m10;
    private CWidgetId m10Id;
    private CWidgetId m10Value;
    private CWidgetId m11;
    private CWidgetId m11List;

    public CTreeUi(@NotNull CTreeModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs304 = CWidgetSetId.create((String)"@304_Tree", (String)instance);
        CWidgetId c001 = CWidgetId.create((String)"#304_Component_001", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(c001, (IListener)((IExpansionListener)aEvent -> this.mModel.getAppContext().addMessage(aEvent.getNodeId() + ": " + aEvent.isExpanded())));
        this.mWs30410 = CWidgetSetId.create((String)"@304_10", (String)instance);
        this.mWs30411 = CWidgetSetId.create((String)"@304_11", (String)instance);
    }

    private void widgetSet304Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m304PanelMain = CWidgetId.create((String)"#304_Panel_Main", (CWidgetSetId)this.mWs304);
        this.m8 = CWidgetId.create((String)"#304_Component_008", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(this.m8, (IListener)((IExpansionListener)this::expansion8));
        this.m8helper = CWidgetId.create((String)"#304_Helper_008", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(this.m8helper, (IListener)((IButtonPressedListener)this::button8));
        this.m9 = CWidgetId.create((String)"#304_Component_009", (CWidgetSetId)this.mWs304);
        this.m9helper = CWidgetId.create((String)"#304_Helper_009", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(this.m9helper, (IListener)((IButtonPressedListener)this::button9));
        this.m10 = CWidgetId.create((String)"#304_Component_010", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(this.m10, (IListener)((ITreeChangeListener)this::m10TreeChangeListener));
        this.m10Id = CWidgetId.create((String)"#304_10_ID", (CWidgetSetId)this.mWs30410);
        this.m10Value = CWidgetId.create((String)"#304_10_Value", (CWidgetSetId)this.mWs30410);
        this.m11 = CWidgetId.create((String)"#304_Component_011", (CWidgetSetId)this.mWs304);
        this.mApi.addListener(this.m11, (IListener)((ITreeSelectionListener)this::on11Selection));
        this.m11List = CWidgetId.create((String)"#304_11_List", (CWidgetSetId)this.mWs30411);
        this.mApi.setVisible(this.m304PanelMain, true);
        this.mServerContext.sendUpdate();
    }

    private void on11Selection(@NotNull CEventTreeSelectionNotification aEvent) {
        this.mApi.clear(this.m11List);
        CEventListContent event = new CEventListContent();
        for (CEventTreeSelectionNotification.CEntry node : aEvent.getSelectedNodes()) {
            CEventLabelItem item = new CEventLabelItem(node.getId());
            item.getAttributes().setValue((Object)node.getValue());
            event.add(item);
            this.mApi.setListContent(this.m11List, event);
        }
        this.mServerContext.sendUpdate();
    }

    private void m10TreeChangeListener(@NotNull CEventTreeChangeNotification aEvent) {
        Collection values = aEvent.getValues();
        for (CEventIdAndValue ev : values) {
            this.mApi.setText(this.m10Id, ev.getId());
            this.mApi.setText(this.m10Value, ev.getValue().toString());
        }
        this.mServerContext.sendUpdate();
    }

    private void button8(@NotNull CEventButtonPressedNotification aEvent) {
        if (this.m8Expanded) {
            this.mApi.collapse(this.m8, "b2");
        } else {
            this.mApi.expand(this.m8, "b2");
        }
        this.mServerContext.sendUpdate();
    }

    private void button9(@NotNull CEventButtonPressedNotification aEvent) {
        if (SEARCH_9_1.equals(this.m9searchString)) {
            this.m9searchString = SEARCH_9_2;
            this.mApi.ensureVisible(this.m9, new CEventEnsureVisible(this.m9searchString));
            this.mApi.setText(this.m9helper, "Search id1-1");
        } else {
            this.m9searchString = SEARCH_9_1;
            this.mApi.ensureVisible(this.m9, new CEventEnsureVisible(this.m9searchString));
            this.mApi.setText(this.m9helper, "Search id14-1");
        }
        this.mServerContext.sendUpdate();
    }

    private void expansion8(@NotNull CEventExpansionNotification aEvent) {
        if (aEvent.getNodeId().equals("b2")) {
            if (aEvent.isExpanded()) {
                this.m8Expanded = true;
                this.mApi.setText(this.m8helper, "Collapse");
                this.mModel.getAppContext().addMessage("Node b2(Node1) collapsed");
            } else {
                this.m8Expanded = false;
                this.mApi.setText(this.m8helper, "Expand");
                this.mModel.getAppContext().addMessage("Node b2(Node1) expanded");
            }
            this.mServerContext.sendUpdate();
        }
    }

    void mountWidgetSet304() {
        this.mServerContext.mountWidgetSet(this.mWs304, this.mModel.getParent(), "#304_Panel_Main", this::widgetSet304Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m304PanelMain);
    }
}

