/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.types;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CDataKeyModifiers {
    private final Set<EKeyModifier> mModifiers = new HashSet<EKeyModifier>();

    @Nullable
    public static CDataKeyModifiers create(@Nullable Object aValue) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            CDataKeyModifiers m = new CDataKeyModifiers();
            for (Object o : arr.getChildren()) {
                EKeyModifier modifier;
                if (!(o instanceof String) || (modifier = (EKeyModifier)CUtilEnum.fromString(EKeyModifier.class, (String)((String)o), (Object)EKeyModifier.unknown)) == EKeyModifier.unknown) continue;
                m.addModifier(modifier);
            }
            return m;
        }
        return null;
    }

    public void addModifier(@NotNull EKeyModifier aModifier) {
        if (aModifier != EKeyModifier.unknown) {
            this.mModifiers.add(aModifier);
        }
    }

    public void addModifiers(@NotNull Collection<EKeyModifier> aModifiers) {
        for (EKeyModifier m : aModifiers) {
            this.addModifier(m);
        }
    }

    @NotNull
    public CJsonArray toJson() {
        CJsonArray arr = new CJsonArray();
        for (EKeyModifier m : this.mModifiers) {
            arr.add((Object)m.name());
        }
        return arr;
    }

    @NotNull
    public Collection<EKeyModifier> getModifiers() {
        return this.mModifiers;
    }

    public boolean isEmpty() {
        return this.mModifiers.isEmpty();
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CDataKeyModifiers that = (CDataKeyModifiers)aO;
        return this.mModifiers.equals(that.mModifiers);
    }

    public int hashCode() {
        return Objects.hash(this.mModifiers);
    }
}

