/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.string.CUtilBase64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventText
implements IRemoteSkinEvent {
    private static final String KEY_DEFAULT = "default";
    private static final String KEY_BASE64 = "base64";
    private String mDefault;
    private String mBase64;
    private String mDecodedText;

    public CEventText() {
    }

    public CEventText(@NotNull String aDefault) {
        this.mDefault = aDefault;
    }

    @Nullable
    public static CEventText create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventText event = new CEventText();
            Object o = jo.getValue(KEY_BASE64);
            if (o instanceof String) {
                String s = CUtilBase64.decodeString((String)((String)o));
                event.setBase64(s);
            }
            if ((o = jo.getValue(KEY_DEFAULT)) instanceof String) {
                event.setDefault((String)o);
            }
            return event;
        }
        if (aValue instanceof String) {
            String s = (String)aValue;
            CEventText event = new CEventText();
            if (s.startsWith("^")) {
                s = CUtilBase64.decodeString((String)((String)aValue));
                event.setBase64(s);
            } else {
                event.setDefault(s);
            }
            return event;
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(KEY_DEFAULT, (Object)this.mDefault);
        jo.put(KEY_BASE64, (Object)this.mBase64);
        return jo;
    }

    @Nullable
    public String getBase64() {
        return this.mBase64;
    }

    public void setBase64(String aBase64) {
        this.mBase64 = aBase64;
    }

    @Nullable
    public String getDefault() {
        return this.mDefault;
    }

    public void setDefault(String aDefault) {
        this.mDefault = aDefault;
    }

    public String getText() {
        if (this.mDecodedText == null) {
            this.mDecodedText = CUtilString.isValid((String)this.mBase64) ? CUtilBase64.decodeStringWithoutPrefix((String)this.mBase64) : this.mDefault;
        }
        return this.mDecodedText;
    }
}

