/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.types.CDataKeyModifiers;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.awt.Point;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventPopupNotification
implements IRemoteSkinEvent {
    public static final String CMD = "cmd";
    public static final String MODIFIERS = "modifiers";
    public static final String COMPONENT = "component";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String ROW_ID = "rowid";
    public static final String COLUMN_ID = "columnid";
    public static final String VALUE = "value";
    private final CDataKeyModifiers mModifiers = new CDataKeyModifiers();
    private String mCommand;
    private CWidgetId mComponent;
    private Point mPosition;
    private String mValue;
    private String mRowId;
    private String mColumnId;

    @Nullable
    public static CEventPopupNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventPopupNotification event = new CEventPopupNotification();
            String command = CUtilJsonString.fromJson((CJsonObject)jo, (String)CMD, (String)"");
            event.setCommand(command);
            CEventWidgetId widgetIdEvent = CEventWidgetId.create(jo.getValue(COMPONENT));
            event.setComponent(widgetIdEvent == null ? null : widgetIdEvent.getWidgetId());
            Object obj = jo.getValue(MODIFIERS);
            CDataKeyModifiers mods = CDataKeyModifiers.create(obj);
            if (mods != null) {
                for (EKeyModifier modifier : mods.getModifiers()) {
                    event.addModifier(modifier);
                }
            }
            int x = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)X, (int)-1);
            int y = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)Y, (int)-1);
            if (x >= 0 && y >= 0) {
                event.setPosition(new Point(x, y));
            }
            String rowId = CUtilJsonString.fromJson((CJsonObject)jo, (String)ROW_ID, (String)"");
            event.setRowId(rowId);
            String columnId = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_ID, (String)"");
            event.setColumnId(columnId);
            String value = CUtilJsonString.fromJson((CJsonObject)jo, (String)VALUE, (String)"");
            event.setValue(value);
            return event;
        }
        return null;
    }

    public void addModifier(@NotNull EKeyModifier aModifier) {
        this.mModifiers.addModifier(aModifier);
    }

    @NotNull
    public String getCommand() {
        return this.mCommand;
    }

    public void setCommand(String aCommand) {
        this.mCommand = aCommand;
    }

    @Nullable
    public CWidgetId getComponent() {
        return this.mComponent;
    }

    public void setComponent(CWidgetId aComponent) {
        this.mComponent = aComponent;
    }

    @Nullable
    public Collection<EKeyModifier> getModifiers() {
        return this.mModifiers.getModifiers();
    }

    @Nullable
    public Point getPosition() {
        return this.mPosition;
    }

    public void setPosition(@Nullable Point aPosition) {
        this.mPosition = aPosition;
    }

    @NotNull
    public String getValue() {
        return this.mValue;
    }

    public void setValue(String aValue) {
        this.mValue = aValue;
    }

    @NotNull
    public String getRowId() {
        return this.mRowId;
    }

    public void setRowId(String aRowId) {
        this.mRowId = aRowId;
    }

    @NotNull
    public String getColumnId() {
        return this.mColumnId;
    }

    public void setColumnId(String aColumnId) {
        this.mColumnId = aColumnId;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (CUtilString.isValid((String)this.mCommand)) {
            jo.put(CMD, (Object)this.mCommand);
        }
        if (!this.mModifiers.isEmpty()) {
            CJsonArray arr = this.mModifiers.toJson();
            jo.put(MODIFIERS, (Object)arr);
        }
        if (this.mPosition != null) {
            jo.put(X, (Object)this.mPosition.x);
            jo.put(Y, (Object)this.mPosition.y);
        }
        if (this.mComponent != null) {
            CEventWidgetId dw = new CEventWidgetId(this.mComponent);
            jo.put(COMPONENT, dw.toJson());
        }
        jo.put(ROW_ID, (Object)this.mRowId);
        jo.put(COLUMN_ID, (Object)this.mColumnId);
        if (CUtilString.isValid((String)this.mValue)) {
            jo.put(VALUE, (Object)this.mValue);
        }
        return jo;
    }
}

