/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionRegistry;
import de.sillysky.nyssr.impl.network.connection.registry.IDependencies;
import de.sillysky.nyssr.impl.network.transport.ITransportFactory;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.hints.IRoutingHintRegistry;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public final class CPackageImplNetworkConnectionRegistry
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IMessageSender mMessageSender;
    private IRouter mRouter;
    private ITransportFactory mTransportFactory;
    private INodeInfoDatabase mNodeInfoDatabase;
    private INameDb mNameDb;
    private INamespaceFactory mNamespaceFactory;
    private ITimerManager mTimerManager;
    private IKernelConfiguration mKernelConfiguration;
    private IRoutingHintRegistry mRoutingHintRegistry;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IRouter.class);
        aDependencyList.add(ITransportFactory.class);
        aDependencyList.add(INodeInfoDatabase.class);
        aDependencyList.add(INameDb.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(ITimerManager.class);
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(ICommandLineInterface.class);
        aDependencyList.add(IRoutingHintRegistry.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mMessageSender = (IMessageSender)aServiceRegistry.getServiceOrThrow(IMessageSender.class);
            this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
            this.mTransportFactory = (ITransportFactory)aServiceRegistry.getServiceOrThrow(ITransportFactory.class);
            this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
            this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
            this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mRoutingHintRegistry = (IRoutingHintRegistry)aServiceRegistry.getServiceOrThrow(IRoutingHintRegistry.class);
            this.mService = new CConnectionRegistry(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }

    @Override
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    public INodeInfoDatabase getNodeInfoDatabase() {
        return this.mNodeInfoDatabase;
    }

    @Override
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    public ITransportFactory getTransportFactory() {
        return this.mTransportFactory;
    }

    @Override
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public IRoutingHintRegistry getRoutingHintRegistry() {
        return this.mRoutingHintRegistry;
    }
}

