/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.kernel.CKernel;
import de.sillysky.nyssr.impl.plugin.CUtilPlugIn;
import de.sillysky.nyssr.impl.software.updater.local.CDownloadRequest;
import de.sillysky.nyssr.impl.software.updater.local.CJobChangeConfiguration;
import de.sillysky.nyssr.impl.software.updater.local.CJobCheckSession;
import de.sillysky.nyssr.impl.software.updater.local.CJobCopyOldFiles;
import de.sillysky.nyssr.impl.software.updater.local.CJobDownloadDirectory;
import de.sillysky.nyssr.impl.software.updater.local.CJobFindMatchingOldFiles;
import de.sillysky.nyssr.impl.software.updater.local.CJobReboot;
import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.impl.software.updater.local.CTargetRebootNode;
import de.sillysky.nyssr.impl.software.updater.local.CUtilVersionStringBuilder;
import de.sillysky.nyssr.impl.software.updater.local.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.software.updater.records.CRecordCancelReboot;
import de.sillysky.nyssr.software.updater.records.CRecordGetPluginList;
import de.sillysky.nyssr.software.updater.records.CRecordReboot;
import de.sillysky.nyssr.software.updater.records.CRecordSetPluginList;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilSystem;
import de.sillysky.nyssr.util.job.serial.INotifyJobsFinished;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CLocalSoftwareUpdater
extends CTarget
implements IService,
INotifyJobsFinished {
    private static final ILogger LOG = CLoggerFactory.getLogger(CLocalSoftwareUpdater.class);
    private static final String REBOOT = "reboot";
    private static final String HELP_REBOOT = "reboot (reboots the current node)\n\treboot --nodes a b c (reboots the nodes a, b and c)\n\treboot -s (reboots all nodes in the segment)\n\treboot --at hh:mm:ss (reboot at the given time)\n\treboot --in 300 (reboot in 300 seconds)";
    private static final String VERSION = "version";
    private static final String HELP_VERSION = "version (downloads a JSON file with version info)";
    private static final Path TEMP_DIR = Paths.get("update", new String[0]).toAbsolutePath();
    private static final Path OLD_FILES_DIR = TEMP_DIR.resolve("old_files");
    private static final Path NEW_FILES_DIR = TEMP_DIR.resolve("new_files");
    private final IDependencies mDependencies;
    private CEnvelope mEnvelopeUpdateRequest;
    private CRecord mRecordUpdateRequest;
    private CSerialJobMachine mSerialJobMachine;

    CLocalSoftwareUpdater(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordReboot.ID, this::asyncReboot);
        this.addMessageHandler(CRecordCancelReboot.ID, this::asyncCancelReboot);
        this.addMessageHandler(CRecordGetPluginList.ID, this::asyncGetPluginList);
        this.addMessageHandler(CRecordSetPluginList.ID, this::asyncSetPluginList);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        INanoServiceRegistry nsr = this.getNamespace().getNanoServiceRegistry();
        CTargetAddress address = this.getAddress();
        nsr.addNanoServiceAndObserver(CRecordReboot.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordCancelReboot.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordGetPluginList.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordSetPluginList.class, address, false);
        this.registerCli();
        return true;
    }

    private boolean asyncReboot(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        System.out.println("Got Reboot: " + String.valueOf(sessionToken == null ? "0" : Integer.valueOf(sessionToken.length)));
        CTargetRebootNode tgt = new CTargetRebootNode(this.mDependencies, aEnvelope, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        return true;
    }

    private boolean asyncCancelReboot(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetPluginList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        List plugins = CUtilPlugIn.loadPluginListFromPreferencesSubNode();
        String[] array = plugins.toArray(new String[0]);
        CRecordGetPluginList.setPluginList((CRecord)aRecord, (String[])array);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSetPluginList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        boolean reboot;
        String[] pluginToLoadList;
        String[] pluginList;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (this.mSerialJobMachine != null) {
            aEnvelope.setResult(4, "Update in progress");
            return true;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        if (sessionToken == null) {
            aEnvelope.setResult(5107, "Missing session token");
            return true;
        }
        this.mSerialJobMachine = new CSerialJobMachine(this);
        this.mSerialJobMachine.setSessionToken(sessionToken);
        this.mSerialJobMachine.enqueueJob(new CJobCheckSession(this.getTargetRegistry(), this.mSerialJobMachine));
        String[] libraryList = CRecordSetPluginList.getLibraryList((CRecord)aRecord, null);
        if (!CUtilStringArray.isEmpty((String[])libraryList)) {
            String scope = "lib";
            Path oldFilesDir = OLD_FILES_DIR.resolve("lib");
            Path newFilesDir = NEW_FILES_DIR.resolve("lib");
            this.mSerialJobMachine.enqueueJob(new CJobCopyOldFiles(this.mSerialJobMachine, this.getLibPath(), oldFilesDir));
            HashMap<String, CDownloadRequest> downloadRequests = new HashMap<String, CDownloadRequest>();
            for (String file : libraryList) {
                CDownloadRequest entry = CDownloadRequest.parse("lib", file);
                downloadRequests.put(entry.toString(), entry);
            }
            this.mSerialJobMachine.enqueueJob(new CJobFindMatchingOldFiles(this.mSerialJobMachine, (ITarget)this, "lib", oldFilesDir, newFilesDir, downloadRequests));
            this.mSerialJobMachine.enqueueJob(new CJobDownloadDirectory(this.getTargetRegistry(), this.mSerialJobMachine, "lib", downloadRequests, NEW_FILES_DIR));
            this.mSerialJobMachine.setLibUpdated(true);
        }
        if (!CUtilStringArray.isEmpty((String[])(pluginList = CRecordSetPluginList.getPluginList((CRecord)aRecord, null)))) {
            String scope = "plugins";
            Path oldFilesDir = OLD_FILES_DIR.resolve("plugins");
            Path newFilesDir = NEW_FILES_DIR.resolve("plugins");
            this.mSerialJobMachine.enqueueJob(new CJobCopyOldFiles(this.mSerialJobMachine, this.getPluginsPath(), oldFilesDir));
            HashMap<String, CDownloadRequest> downloadRequests = new HashMap<String, CDownloadRequest>();
            for (String file : pluginList) {
                CDownloadRequest entry = CDownloadRequest.parse("plugins", file);
                downloadRequests.put(entry.toString(), entry);
            }
            this.mSerialJobMachine.enqueueJob(new CJobFindMatchingOldFiles(this.mSerialJobMachine, (ITarget)this, "plugins", oldFilesDir, newFilesDir, downloadRequests));
            this.mSerialJobMachine.enqueueJob(new CJobDownloadDirectory(this.getTargetRegistry(), this.mSerialJobMachine, "plugins", downloadRequests, NEW_FILES_DIR));
            this.mSerialJobMachine.setPluginsUpdated(true);
        }
        if (!CUtilStringArray.isEmpty((String[])(pluginToLoadList = CRecordSetPluginList.getPluginToLoadList((CRecord)aRecord, null)))) {
            this.mSerialJobMachine.enqueueJob(new CJobChangeConfiguration(this.mDependencies, this.mSerialJobMachine, pluginToLoadList));
        }
        if (reboot = CRecordSetPluginList.getReboot((CRecord)aRecord, (boolean)false)) {
            this.mSerialJobMachine.enqueueJob(new CJobReboot(this.mSerialJobMachine));
        }
        aEnvelope.setBlocked(true);
        this.mEnvelopeUpdateRequest = aEnvelope;
        this.mRecordUpdateRequest = aRecord;
        System.out.println("Software update running...");
        this.mSerialJobMachine.start();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (REBOOT.equals(command)) {
            if (sessionToken == null) {
                CRecordCliHandle.getIsValidCommand((CRecord)aRecord, (boolean)true);
                aEnvelope.setResult(5107, "Please login first.");
            } else {
                CTargetRebootNode tgt = new CTargetRebootNode(this.mDependencies, aEnvelope, aRecord);
                this.getTargetRegistry().registerTarget((ITarget)tgt);
                aEnvelope.setResultSuccess();
            }
        } else if (VERSION.equals(command)) {
            String version = CUtilVersionStringBuilder.getVersion(this.mDependencies, sessionToken);
            CRecordCliHandle.setOutput((CRecord)aRecord, (String)version);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private void registerCli() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{REBOOT, VERSION});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{HELP_REBOOT, HELP_VERSION});
        this.sendNotification(env, record);
    }

    public void notifyJobsFinished(int aResultCode, @NotNull String aResultText) {
        this.mSerialJobMachine = null;
        if (this.mEnvelopeUpdateRequest != null && this.mRecordUpdateRequest != null) {
            if (aResultCode != 0) {
                LOG.error("Error software update: {}-{}", new Object[]{aResultCode, aResultText});
            } else {
                LOG.info("Software Update finished successfully");
            }
            this.mEnvelopeUpdateRequest.setResult(aResultCode, aResultText);
            this.mEnvelopeUpdateRequest.setBlocked(false);
            try {
                this.getMessageSender().sendBack(this.mEnvelopeUpdateRequest, this.mRecordUpdateRequest);
            }
            catch (CException aException) {
                LOG.error("Couldn't return message: {}", new Object[]{aException.toString()});
            }
            this.mEnvelopeUpdateRequest = null;
            this.mRecordUpdateRequest = null;
        }
    }

    @NotNull
    private Path getLibPath() {
        String libPath;
        try {
            libPath = CUtilSystem.findJarPathString(CKernel.class);
        }
        catch (URISyntaxException aException) {
            libPath = "../lib";
            LOG.error((Throwable)aException, "Error when determining the kernel jar path");
        }
        return Paths.get(libPath, new String[0]).toAbsolutePath().normalize();
    }

    @NotNull
    private Path getPluginsPath() {
        String pluginsPath;
        try {
            pluginsPath = CUtilSystem.findJarPathString(CLocalSoftwareUpdater.class);
        }
        catch (URISyntaxException aException) {
            pluginsPath = "../plugins";
            LOG.error((Throwable)aException, "Error when determining the plugin path");
        }
        return Paths.get(pluginsPath, new String[0]).toAbsolutePath().normalize();
    }
}

