/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventShowInputDialog
implements IRemoteSkinEvent {
    public static final String KEY_TITLE = "title";
    public static final String KEY_TEXT = "text";
    public static final String KEY_DEFAULT_TEXT = "default";
    public static final String KEY_ICON = "icon";
    public static final String DEFAULT_TITLE = "String Input:";
    public static final String DEFAULT_TEXT = "";
    public static final String DEFAULT_DEFAULT_TEXT = "";
    private String mTitle;
    private String mText;
    private String mDefaultText;
    private CEventIcon mIcon;

    @Nullable
    public static CEventShowInputDialog create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventShowInputDialog event = new CEventShowInputDialog();
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_TITLE, (String)DEFAULT_TITLE);
            event.setTitle(title);
            String text = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_TEXT, (String)"");
            event.setText(text);
            String defaultText = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_DEFAULT_TEXT, (String)"");
            event.setDefaultText(defaultText);
            CEventIcon icon = CEventIcon.fromObject(jo.getValue(KEY_ICON));
            if (icon != null) {
                event.setIcon(icon);
            }
            return event;
        }
        return null;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String aTitle) {
        this.mTitle = aTitle;
    }

    @NotNull
    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @NotNull
    public String getDefaultText() {
        return this.mDefaultText;
    }

    public void setDefaultText(String aDefaultText) {
        this.mDefaultText = aDefaultText;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(KEY_TITLE, (Object)this.mTitle);
        jo.put(KEY_TEXT, (Object)this.mText);
        if (CUtilString.isValid((String)this.mDefaultText)) {
            jo.put(KEY_DEFAULT_TEXT, (Object)this.mDefaultText);
        }
        if (this.mIcon != null) {
            jo.put(KEY_ICON, this.mIcon.toJson());
        }
        return jo;
    }

    @Nullable
    public CEventIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(CEventIcon aIcon) {
        this.mIcon = aIcon;
    }
}

