/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.dialogs;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.CEventMnemonic;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventShowFileChooserDialog
implements IRemoteSkinEvent {
    static final String KEY_PATH = "path";
    static final String KEY_DIALOG_TYPE = "dlgtype";
    static final String KEY_APPROVE_BUTTON_TEXT = "approvebutton";
    static final String KEY_FILE_FILTER = "filefilter";
    static final String KEY_SELECTION_MODE = "selectionmode";
    static final String KEY_TITLE = "title";
    static final String KEY_SHOW_HIDDEN_FILES = "showhiddenfiles";
    static final String KEY_MULTI_SELECTION_ENABLED = "multiselectionenabled";
    static final String KEY_SELECTED_FILES = "selectedfiles";
    static final String KEY_MNEMONIC = "mnemonic";
    static final String KEY_TOOLTIP = "tooltip";
    static final String KEY_ADD_ALL_FILES_FILTER = "all";
    static final String DEFAULT_PATH = null;
    static final EDialogType DEFAULT_DIALOG_TYPE = EDialogType.neutral;
    static final String DEFAULT_APPROVE_BUTTON_TEXT = "Okay";
    static final CEventMnemonic DEFAULT_MNEMONIC = new CEventMnemonic("O");
    static final ESelectionMode DEFAULT_SELECTION_MODE = ESelectionMode.files;
    static final String DEFAULT_TITLE = "Select Files";
    static final boolean DEFAULT_SHOW_HIDDEN_FILES = false;
    static final boolean DEFAULT_MULTI_SELECTION_ENABLED = false;
    static final String DEFAULT_TOOLTIP = "";
    static final boolean DEFAULT_ADD_ALL_FILE_FILTER = true;
    private final List<CFileFilter> mFileFilterList = new ArrayList<CFileFilter>();
    private final Set<String> mSelectedFiles = new HashSet<String>();
    private ESelectionMode mSelectionMode = DEFAULT_SELECTION_MODE;
    private String mPath;
    private String mTitle;
    private EDialogType mDialogType = DEFAULT_DIALOG_TYPE;
    private String mApproveButtonText = "Okay";
    private boolean mShowHiddenFiles = false;
    private boolean mMultiSelectionEnabled = false;
    private CEventMnemonic mApproveButtonMnemonic = DEFAULT_MNEMONIC;
    private String mApproveButtonTooltip = "";
    private boolean mAddAllFilesFilter = true;

    @Nullable
    public static CEventShowFileChooserDialog create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            CEventShowFileChooserDialog event = new CEventShowFileChooserDialog();
            String path = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_PATH, (String)DEFAULT_PATH);
            event.setPath(path);
            Object o = jo.getValue(KEY_SELECTED_FILES);
            if (o instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)o;
                for (Object child : arr.getChildren()) {
                    event.addSelectedFile(child.toString());
                }
            }
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_TITLE, (String)DEFAULT_TITLE);
            event.setTitle(title);
            o = jo.getValue(KEY_DIALOG_TYPE);
            if (o instanceof String) {
                EDialogType dialogType = (EDialogType)((Object)CUtilEnum.fromString(EDialogType.class, (String)((String)o), (Object)((Object)DEFAULT_DIALOG_TYPE)));
                event.setDialogType(dialogType);
            }
            if ((o = jo.getValue(KEY_SELECTION_MODE)) instanceof String) {
                ESelectionMode selectionMode = (ESelectionMode)((Object)CUtilEnum.fromString(ESelectionMode.class, (String)((String)o), (Object)((Object)DEFAULT_SELECTION_MODE)));
                event.setSelectionMode(selectionMode);
            }
            String approveButtonText = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_APPROVE_BUTTON_TEXT, (String)DEFAULT_APPROVE_BUTTON_TEXT);
            event.setApproveButtonText(approveButtonText);
            String tooltip = CUtilJsonString.fromJson((CJsonObject)jo, (String)KEY_TOOLTIP, (String)DEFAULT_TOOLTIP);
            event.setApproveButtonTooltip(tooltip);
            CEventMnemonic eventMnemonic = CEventMnemonic.create(jo.getValue(KEY_MNEMONIC));
            event.setApproveButtonMnemonic(eventMnemonic);
            o = jo.getValue(KEY_FILE_FILTER);
            if (o instanceof CJsonArray) {
                CJsonArray arr = (CJsonArray)o;
                for (Object child : arr.getChildren()) {
                    CFileFilter ff = CFileFilter.create(child);
                    if (ff == null) continue;
                    event.addFileFilter(ff);
                }
            }
            boolean showHiddenFiles = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_SHOW_HIDDEN_FILES, (boolean)false);
            event.setShowHiddenFiles(showHiddenFiles);
            boolean multiSelectionEnabled = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_MULTI_SELECTION_ENABLED, (boolean)false);
            event.setMultiSelectionEnabled(multiSelectionEnabled);
            boolean addAllFilesFilter = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)KEY_ADD_ALL_FILES_FILTER, (boolean)true);
            event.setAddAllFilesFilter(addAllFilesFilter);
            return event;
        }
        return null;
    }

    public boolean isAddAllFilesFilter() {
        return this.mAddAllFilesFilter;
    }

    public void setAddAllFilesFilter(boolean aAddAllFilesFilter) {
        this.mAddAllFilesFilter = aAddAllFilesFilter;
    }

    public String getApproveButtonTooltip() {
        return this.mApproveButtonTooltip;
    }

    public void setApproveButtonTooltip(String aApproveButtonTooltip) {
        this.mApproveButtonTooltip = aApproveButtonTooltip;
    }

    @Nullable
    public CEventMnemonic getApproveButtonMnemonic() {
        return this.mApproveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(@Nullable CEventMnemonic aMnemonic) {
        this.mApproveButtonMnemonic = aMnemonic;
    }

    @NotNull
    public Collection<String> getSelectedFiles() {
        return this.mSelectedFiles;
    }

    public void addSelectedFile(@NotNull String aSelectedFile) {
        this.mSelectedFiles.add(aSelectedFile);
    }

    public boolean isMultiSelectionEnabled() {
        return this.mMultiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean aMultiSelectionEnabled) {
        this.mMultiSelectionEnabled = aMultiSelectionEnabled;
    }

    public boolean isShowHiddenFiles() {
        return this.mShowHiddenFiles;
    }

    public void setShowHiddenFiles(boolean aShowHiddenFiles) {
        this.mShowHiddenFiles = aShowHiddenFiles;
    }

    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(@NotNull String aTitle) {
        this.mTitle = aTitle;
    }

    @NotNull
    public ESelectionMode getSelectionMode() {
        return this.mSelectionMode;
    }

    public void setSelectionMode(@NotNull ESelectionMode aSelectionMode) {
        this.mSelectionMode = aSelectionMode;
    }

    @NotNull
    public String getApproveButtonText() {
        return this.mApproveButtonText;
    }

    public void setApproveButtonText(@NotNull String aApproveButtonText) {
        this.mApproveButtonText = aApproveButtonText;
    }

    @NotNull
    public EDialogType getDialogType() {
        return this.mDialogType;
    }

    public void setDialogType(@NotNull EDialogType aDialogType) {
        this.mDialogType = aDialogType;
    }

    public void addFileFilter(@NotNull String aDescription, String ... aExtension) {
        this.addFileFilter(new CFileFilter(aDescription, aExtension));
    }

    public void addFileFilter(@NotNull CFileFilter aFilter) {
        this.mFileFilterList.add(aFilter);
    }

    @NotNull
    public List<CFileFilter> getFileFilterList() {
        return this.mFileFilterList;
    }

    @Nullable
    public String getPath() {
        return this.mPath;
    }

    public void setPath(String aPath) {
        this.mPath = aPath;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonArray arr;
        CJsonObject jo = new CJsonObject(true);
        if (this.mPath != null && !this.mPath.equals(DEFAULT_PATH)) {
            jo.put(KEY_PATH, (Object)this.mPath);
        }
        if (!this.mSelectedFiles.isEmpty()) {
            arr = new CJsonArray();
            for (String file : this.mSelectedFiles) {
                arr.add((Object)file);
            }
            jo.put(KEY_SELECTED_FILES, (Object)arr);
        }
        if (!DEFAULT_TITLE.equals(this.mTitle)) {
            jo.put(KEY_TITLE, (Object)this.mTitle);
        }
        if (this.mDialogType != DEFAULT_DIALOG_TYPE) {
            jo.put(KEY_DIALOG_TYPE, (Object)this.mDialogType.name());
        }
        if (this.mSelectionMode != DEFAULT_SELECTION_MODE) {
            jo.put(KEY_SELECTION_MODE, (Object)this.mSelectionMode.name());
        }
        if (!DEFAULT_APPROVE_BUTTON_TEXT.equals(this.mApproveButtonText)) {
            jo.put(KEY_APPROVE_BUTTON_TEXT, (Object)this.mApproveButtonText);
        }
        if (this.mApproveButtonMnemonic != null) {
            jo.put(KEY_MNEMONIC, this.mApproveButtonMnemonic.toJson());
        }
        if (!DEFAULT_TOOLTIP.equals(this.mApproveButtonTooltip)) {
            jo.put(KEY_TOOLTIP, (Object)this.mApproveButtonTooltip);
        }
        if (!this.mFileFilterList.isEmpty()) {
            arr = new CJsonArray();
            for (CFileFilter filter : this.mFileFilterList) {
                arr.add(filter.toJson());
            }
            jo.put(KEY_FILE_FILTER, (Object)arr);
        }
        if (this.mShowHiddenFiles) {
            jo.put(KEY_SHOW_HIDDEN_FILES, (Object)this.mShowHiddenFiles);
        }
        if (this.mMultiSelectionEnabled) {
            jo.put(KEY_MULTI_SELECTION_ENABLED, (Object)this.mMultiSelectionEnabled);
        }
        if (!this.mAddAllFilesFilter) {
            jo.put(KEY_ADD_ALL_FILES_FILTER, (Object)this.mAddAllFilesFilter);
        }
        return jo;
    }

    public static enum ESelectionMode {
        files,
        directories,
        both;

    }

    public static enum EDialogType {
        open,
        save,
        neutral;

    }

    public static class CFileFilter {
        private final String mDescription;
        private final String[] mExtensions;

        public CFileFilter(String aDescription, String[] aExtensions) {
            this.mDescription = aDescription;
            this.mExtensions = aExtensions;
        }

        @Nullable
        public static CFileFilter create(@Nullable Object aValue) {
            CJsonArray array;
            int size;
            if (aValue instanceof CJsonArray && (size = (array = (CJsonArray)aValue).size()) > 1) {
                String[] ext = new String[size - 1];
                for (int i = 1; i < size; ++i) {
                    Object o = array.getValue(i);
                    ext[i - 1] = o.toString();
                }
                String desc = array.getValue(0).toString();
                return new CFileFilter(desc, ext);
            }
            return null;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String[] getExtensions() {
            return this.mExtensions;
        }

        @NotNull
        private Object toJson() {
            CJsonArray jo = new CJsonArray();
            jo.add((Object)this.mDescription);
            for (String ext : this.mExtensions) {
                jo.add((Object)ext);
            }
            return jo;
        }
    }
}

