/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EColumnType;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableColumn
implements IRemoteSkinEvent {
    public static final String COLUMN_ID = "columnId";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_FORMAT = "format";
    public static final String COLUMN_MINIMUM_WIDTH = "minimumWidth";
    public static final String COLUMN_MAXIMUM_WIDTH = "maximumWidth";
    public static final String COLUMN_PREFERRED_WIDTH = "preferredWidth";
    public static final String COLUMN_IS_EDITABLE = "editable";
    public static final String COLUMN_BACKGROUND = "background";
    public static final String COLUMN_FOREGROUND = "foreground";
    public static final String COLUMN_BORDER = "border";
    public static final String COLUMN_FONT = "font";
    public static final String COLUMN_RESIZABLE = "resizable";
    public static final String COLUMN_WIDTH_TO_FIT = "widthToFit";
    public static final String COLUMN_ICON = "icon";
    private final String mId;
    private EColumnType mType;
    private String mFormat;
    private int mMinimumColumnWidth;
    private int mMaximumColumnWidth;
    private int mPreferredColumnWidth;
    private Boolean mCellsEditable;
    private Boolean mResizable;
    private Boolean mWidthToFit;
    private Color mBackground;
    private Color mForeground;
    private IBorder mBorder;
    private CEventFont mFont;
    private CEventIcon mIcon;

    public CEventTableColumn(@NotNull String aId) {
        this.mId = aId;
    }

    @Nullable
    public static CEventTableColumn create(@Nullable Object aValue) {
        CJsonObject jo;
        String id;
        if (aValue instanceof CJsonObject && CUtilString.isValid((String)(id = CUtilJsonString.fromJson((CJsonObject)(jo = (CJsonObject)aValue), (String)COLUMN_ID, (String)"")))) {
            CEventFont font;
            IBorder border;
            CEventColor ev2;
            CEventColor ev1;
            CEventTableColumn event = new CEventTableColumn(id);
            String typeString = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_TYPE, (String)EColumnType.text.name());
            EColumnType type = (EColumnType)((Object)CUtilEnum.fromString(EColumnType.class, (String)typeString, (Object)((Object)EColumnType.text)));
            event.setType(type);
            int minimumWidth = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)COLUMN_MINIMUM_WIDTH, (int)-1);
            event.setMinimumWidth(minimumWidth);
            int maximumWidth = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)COLUMN_MAXIMUM_WIDTH, (int)-1);
            event.setMaximumWidth(maximumWidth);
            int preferredWidth = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)COLUMN_PREFERRED_WIDTH, (int)-1);
            event.setPreferredWidth(preferredWidth);
            Object o = jo.getValue(COLUMN_IS_EDITABLE);
            if (o != null) {
                boolean isEditable = CUtilBoolean.fromObject((Object)o, (boolean)false);
                event.setCellsEditable(isEditable);
            }
            if ((o = jo.getValue(COLUMN_RESIZABLE)) != null) {
                boolean resizable = CUtilBoolean.fromObject((Object)o, (boolean)false);
                event.setResizable(resizable);
            }
            if ((o = jo.getValue(COLUMN_WIDTH_TO_FIT)) != null) {
                boolean widthToFit = CUtilBoolean.fromObject((Object)o, (boolean)false);
                event.setWidthToFit(widthToFit);
            }
            if ((ev1 = CEventColor.create(jo.getValue(COLUMN_BACKGROUND))) != null) {
                event.setBackground(ev1.createColor());
            }
            if ((ev2 = CEventColor.create(jo.getValue(COLUMN_FOREGROUND))) != null) {
                event.setForeground(ev2.createColor());
            }
            if ((o = jo.getValue(COLUMN_FORMAT)) instanceof String) {
                event.setFormat((String)o);
            }
            if ((border = CJsonBorderUtil.create(jo.getValue(COLUMN_BORDER))) != null) {
                event.setBorder(border);
            }
            if ((font = CEventFont.create(jo.getValue(COLUMN_FONT))) != null) {
                event.setFont(font);
            }
            return event;
        }
        return null;
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public EColumnType getType() {
        return this.mType;
    }

    public void setType(EColumnType aType) {
        this.mType = aType;
    }

    @Nullable
    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String aFormat) {
        this.mFormat = aFormat;
    }

    public int getMinimumColumnWidth() {
        return this.mMinimumColumnWidth;
    }

    public int getMaximumColumnWidth() {
        return this.mMaximumColumnWidth;
    }

    public int getPreferredColumnWidth() {
        return this.mPreferredColumnWidth;
    }

    @Nullable
    public Boolean isColumnCellsEditable() {
        return this.mCellsEditable;
    }

    @Nullable
    public Boolean isResizable() {
        return this.mResizable;
    }

    @Nullable
    public Boolean isWidthToFit() {
        return this.mWidthToFit;
    }

    @Nullable
    public Color getBackground() {
        return this.mBackground;
    }

    public void setBackground(Color aBackground) {
        this.mBackground = aBackground;
    }

    @Nullable
    public Color getForeground() {
        return this.mForeground;
    }

    public void setForeground(Color aForeground) {
        this.mForeground = aForeground;
    }

    @Nullable
    public IBorder getBorder() {
        return this.mBorder;
    }

    public void setBorder(IBorder aBorder) {
        this.mBorder = aBorder;
    }

    @Nullable
    public CEventFont getFont() {
        return this.mFont;
    }

    public void setFont(CEventFont aFont) {
        this.mFont = aFont;
    }

    @Nullable
    public CEventIcon getIcon() {
        return this.mIcon;
    }

    public void setIcon(CEventIcon aIcon) {
        this.mIcon = aIcon;
    }

    @Override
    @NotNull
    public Object toJson() {
        CEventColor ec;
        CJsonObject jo = new CJsonObject(true);
        jo.put(COLUMN_ID, (Object)this.mId);
        if (this.mType != null) {
            jo.put(COLUMN_TYPE, (Object)this.mType.name());
        }
        if (this.mMinimumColumnWidth >= 0) {
            jo.put(COLUMN_MINIMUM_WIDTH, (Object)this.mMinimumColumnWidth);
        }
        if (this.mMaximumColumnWidth >= 0) {
            jo.put(COLUMN_MAXIMUM_WIDTH, (Object)this.mMaximumColumnWidth);
        }
        if (this.mPreferredColumnWidth >= 0) {
            jo.put(COLUMN_PREFERRED_WIDTH, (Object)this.mPreferredColumnWidth);
        }
        if (this.mCellsEditable != null) {
            jo.put(COLUMN_IS_EDITABLE, (Object)this.mCellsEditable);
        }
        if (this.mResizable != null) {
            jo.put(COLUMN_RESIZABLE, (Object)this.mResizable);
        }
        if (this.mWidthToFit != null) {
            jo.put(COLUMN_WIDTH_TO_FIT, (Object)this.mWidthToFit);
        }
        if (this.mBackground != null) {
            ec = new CEventColor(this.mBackground);
            jo.put(COLUMN_BACKGROUND, ec.toJson());
        }
        if (CUtilString.isValid((String)this.mFormat)) {
            jo.put(COLUMN_FORMAT, (Object)this.mFormat);
        }
        if (this.mForeground != null) {
            ec = new CEventColor(this.mForeground);
            jo.put(COLUMN_FOREGROUND, ec.toJson());
        }
        if (this.mBorder != null) {
            jo.put(COLUMN_BORDER, this.mBorder.toJson());
        }
        if (this.mFont != null) {
            jo.put(COLUMN_FONT, this.mFont.toJson());
        }
        if (this.mIcon != null) {
            jo.put(COLUMN_ICON, this.mIcon.toJson());
        }
        return jo;
    }

    public void setMinimumWidth(int aMinimumWidth) {
        this.mMinimumColumnWidth = aMinimumWidth;
    }

    public void setMaximumWidth(int aMaximumWidth) {
        this.mMaximumColumnWidth = aMaximumWidth;
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.mPreferredColumnWidth = aPreferredWidth;
    }

    public void setCellsEditable(boolean aEditable) {
        this.mCellsEditable = aEditable;
    }

    public void setResizable(boolean aResizable) {
        this.mResizable = aResizable;
    }

    public void setWidthToFit(boolean aWidthToFit) {
        this.mWidthToFit = aWidthToFit;
    }
}

